/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.google.httpclient;

import com.navercorp.pinpoint.bootstrap.async.AsyncContextAccessor;
import com.navercorp.pinpoint.bootstrap.instrument.ClassFilter;
import com.navercorp.pinpoint.bootstrap.instrument.ClassFilters;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentClass;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentException;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentMethod;
import com.navercorp.pinpoint.bootstrap.instrument.Instrumentor;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformCallback;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplate;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplateAware;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.ExecutionPolicy;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPlugin;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPluginSetupContext;
import com.navercorp.pinpoint.plugin.google.httpclient.HttpClientPluginConfig;
import java.security.ProtectionDomain;

public class HttpClientPlugin
implements ProfilerPlugin,
TransformTemplateAware {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private TransformTemplate transformTemplate;

    public void setup(ProfilerPluginSetupContext context) {
        HttpClientPluginConfig config = new HttpClientPluginConfig(context.getConfig());
        this.logger.debug("[GoogleHttpClient] Initialized config={}", (Object)config);
        this.logger.debug("[GoogleHttpClient] Add HttpRequest class.");
        this.addHttpRequestClass(config);
    }

    private void addHttpRequestClass(final HttpClientPluginConfig config) {
        this.transformTemplate.transform("com.google.api.client.http.HttpRequest", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                InstrumentMethod execute = target.getDeclaredMethod("execute", new String[0]);
                if (execute != null) {
                    execute.addInterceptor("com.navercorp.pinpoint.plugin.google.httpclient.interceptor.HttpRequestExecuteMethodInterceptor");
                }
                if (config.isAsync()) {
                    InstrumentMethod executeAsync = target.getDeclaredMethod("executeAsync", new String[]{"java.util.concurrent.Executor"});
                    if (executeAsync != null) {
                        executeAsync.addScopedInterceptor("com.navercorp.pinpoint.plugin.google.httpclient.interceptor.HttpRequestExecuteAsyncMethodInterceptor", "ExecuteAsyncScope", ExecutionPolicy.ALWAYS);
                    }
                    for (InstrumentClass nestedClass : target.getNestedClasses(ClassFilters.chain((ClassFilter[])new ClassFilter[]{ClassFilters.enclosingMethod((String)"executeAsync", (String[])new String[]{"java.util.concurrent.Executor"}), ClassFilters.interfaze((String[])new String[]{"java.util.concurrent.Callable"})}))) {
                        HttpClientPlugin.this.logger.debug("Find nested class {}", (Object)target.getName());
                        instrumentor.transform(loader, nestedClass.getName(), new TransformCallback(){

                            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                                InstrumentMethod m;
                                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                                target.addField(AsyncContextAccessor.class.getName());
                                InstrumentMethod constructor = target.getConstructor(new String[]{"com.google.api.client.http.HttpRequest"});
                                if (constructor != null) {
                                    HttpClientPlugin.this.logger.debug("Add constructor interceptor for nested class {}", (Object)target.getName());
                                    constructor.addScopedInterceptor("com.navercorp.pinpoint.plugin.google.httpclient.interceptor.HttpRequestExecuteAsyncMethodInnerClassConstructorInterceptor", "ExecuteAsyncScope", ExecutionPolicy.ALWAYS);
                                }
                                if ((m = target.getDeclaredMethod("call", new String[0])) != null) {
                                    HttpClientPlugin.this.logger.debug("Add method interceptor for nested class {}.{}", (Object)target.getName(), (Object)m.getName());
                                    m.addInterceptor("com.navercorp.pinpoint.plugin.google.httpclient.interceptor.HttpRequestExecuteAsyncMethodInnerClassCallMethodInterceptor");
                                }
                                return target.toBytecode();
                            }
                        });
                    }
                }
                return target.toBytecode();
            }
        });
    }

    public void setTransformTemplate(TransformTemplate transformTemplate) {
        this.transformTemplate = transformTemplate;
    }
}

