/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.sender;

import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.profiler.context.module.SpanConverter;
import com.navercorp.pinpoint.profiler.context.thrift.MessageConverter;
import com.navercorp.pinpoint.profiler.sender.DataSender;
import com.navercorp.pinpoint.profiler.sender.NioUDPDataSender;
import com.navercorp.pinpoint.profiler.sender.ThriftUdpMessageSerializer;
import com.navercorp.pinpoint.profiler.sender.UdpDataSender;
import com.navercorp.pinpoint.profiler.sender.UdpDataSenderType;
import org.apache.thrift.TBase;

public final class UdpDataSenderFactory {
    private final String host;
    private final int port;
    private final String threadName;
    private final int queueSize;
    private final int timeout;
    private final int sendBufferSize;
    private final MessageConverter<TBase<?, ?>> messageConverter;

    public UdpDataSenderFactory(String host, int port, String threadName, int queueSize, int timeout, int sendBufferSize, @SpanConverter MessageConverter<TBase<?, ?>> messageConverter) {
        this.host = host;
        this.port = port;
        this.threadName = threadName;
        this.queueSize = queueSize;
        this.timeout = timeout;
        this.sendBufferSize = sendBufferSize;
        this.messageConverter = (MessageConverter)Assert.requireNonNull(messageConverter, (String)"messageConverter must not be null");
    }

    public DataSender create(String typeName) {
        return this.create(UdpDataSenderType.valueOf(typeName));
    }

    public DataSender create(UdpDataSenderType type) {
        if (type == UdpDataSenderType.NIO) {
            return new NioUDPDataSender(this.host, this.port, this.threadName, this.queueSize, this.timeout, this.sendBufferSize, this.messageConverter);
        }
        if (type == UdpDataSenderType.OIO) {
            ThriftUdpMessageSerializer thriftMessageSerializer = new ThriftUdpMessageSerializer(this.messageConverter, 65507);
            return new UdpDataSender(this.host, this.port, this.threadName, this.queueSize, this.timeout, this.sendBufferSize, thriftMessageSerializer);
        }
        throw new IllegalArgumentException("Unknown type.");
    }
}

