/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.metadata;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.ConcurrentMap;

public class LRUCache<T> {
    private static final Object V = new Object();
    public static final int DEFAULT_CACHE_SIZE = 1024;
    private final ConcurrentMap<T, Object> cache;

    public LRUCache(int maxCacheSize) {
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder();
        cacheBuilder.concurrencyLevel(32);
        cacheBuilder.initialCapacity(maxCacheSize);
        cacheBuilder.maximumSize((long)maxCacheSize);
        Cache localCache = cacheBuilder.build();
        this.cache = localCache.asMap();
    }

    public LRUCache() {
        this(1024);
    }

    public boolean put(T value) {
        Object oldValue = this.cache.putIfAbsent(value, V);
        return oldValue == null;
    }

    public long getSize() {
        return this.cache.size();
    }
}

