/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider.stat.datasource;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.profiler.monitor.collector.AgentStatMetricCollector;
import com.navercorp.pinpoint.profiler.monitor.collector.UnsupportedMetricCollector;
import com.navercorp.pinpoint.profiler.monitor.collector.datasource.DefaultDataSourceMetricCollector;
import com.navercorp.pinpoint.profiler.monitor.metric.datasource.DataSourceMetric;
import com.navercorp.pinpoint.thrift.dto.TDataSourceList;

public class DataSourceMetricCollectorProvider
implements Provider<AgentStatMetricCollector<TDataSourceList>> {
    private final DataSourceMetric dataSourceMetric;

    @Inject
    public DataSourceMetricCollectorProvider(DataSourceMetric dataSourceMetric) {
        this.dataSourceMetric = (DataSourceMetric)Assert.requireNonNull((Object)dataSourceMetric, (String)"dataSourceMetric must not be null");
    }

    public AgentStatMetricCollector<TDataSourceList> get() {
        if (this.dataSourceMetric == DataSourceMetric.UNSUPPORTED_DATA_SOURCE_METRIC) {
            return new UnsupportedMetricCollector<TDataSourceList>();
        }
        return new DefaultDataSourceMetricCollector(this.dataSourceMetric);
    }
}

