/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context;

import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceId;
import com.navercorp.pinpoint.common.annotations.InterfaceAudience;
import com.navercorp.pinpoint.profiler.context.BaseTraceFactory;
import com.navercorp.pinpoint.profiler.context.LocalAsyncId;
import com.navercorp.pinpoint.profiler.context.id.TraceRoot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingBaseTraceFactory
implements BaseTraceFactory {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private BaseTraceFactory baseTraceFactory;

    public static BaseTraceFactory wrap(BaseTraceFactory baseTraceFactory) {
        if (baseTraceFactory == null) {
            throw new NullPointerException("baseTraceFactory must not be null");
        }
        return new LoggingBaseTraceFactory(baseTraceFactory);
    }

    private LoggingBaseTraceFactory(BaseTraceFactory baseTraceFactory) {
        if (baseTraceFactory == null) {
            throw new NullPointerException("baseTraceFactory must not be null");
        }
        this.baseTraceFactory = baseTraceFactory;
    }

    @Override
    public Trace disableSampling() {
        this.logger.debug("disableSampling()");
        return this.baseTraceFactory.disableSampling();
    }

    @Override
    public Trace continueTraceObject(TraceId traceId) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("continueTraceObject(traceId:{})", (Object)traceId);
        }
        return this.baseTraceFactory.continueTraceObject(traceId);
    }

    @Override
    @InterfaceAudience.LimitedPrivate(value={"vert.x"})
    public Trace continueAsyncTraceObject(TraceId traceId) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("continueAsyncTraceObject(traceId:{})", (Object)traceId);
        }
        return this.baseTraceFactory.continueAsyncTraceObject(traceId);
    }

    @Override
    public Trace continueAsyncTraceObject(TraceRoot traceRoot, LocalAsyncId localAsyncId) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("continueAsyncTraceObject(traceRoot:{}, localAsyncId:{})", (Object)traceRoot, (Object)localAsyncId);
        }
        return this.baseTraceFactory.continueAsyncTraceObject(traceRoot, localAsyncId);
    }

    @Override
    public Trace newTraceObject() {
        this.logger.debug("newTraceObject()");
        return this.baseTraceFactory.newTraceObject();
    }

    @Override
    @InterfaceAudience.LimitedPrivate(value={"vert.x"})
    public Trace newAsyncTraceObject() {
        this.logger.debug("newAsyncTraceObject()");
        return this.baseTraceFactory.newAsyncTraceObject();
    }
}

