/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.cxf.interceptor;

import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.context.TraceId;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.plugin.cxf.CxfPluginConfig;
import com.navercorp.pinpoint.plugin.cxf.CxfPluginConstants;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;

@Deprecated
public class CxfClientHandleMessageMethodInterceptor
implements AroundInterceptor {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final TraceContext traceContext;
    private final MethodDescriptor descriptor;
    private final CxfPluginConfig pluginConfig;

    public CxfClientHandleMessageMethodInterceptor(TraceContext traceContext, MethodDescriptor descriptor) {
        this.traceContext = traceContext;
        this.descriptor = descriptor;
        this.pluginConfig = new CxfPluginConfig(traceContext.getProfilerConfig());
    }

    public void before(Object target, Object[] args) {
        String destination;
        Trace trace;
        if (this.logger.isDebugEnabled()) {
            this.logger.beforeInterceptor(target, args);
        }
        if ((trace = this.traceContext.currentRawTraceObject()) != null && trace.canSampled() && (destination = this.getDestination(args)) != null) {
            String httpUri = this.getHttpUri(args);
            String requestMethod = this.getRequestMethod(args);
            String contentType = this.getContentType(args);
            SpanEventRecorder recorder = trace.traceBlockBegin();
            TraceId nextId = trace.getTraceId().getNextTraceId();
            recorder.recordNextSpanId(nextId.getSpanId());
            recorder.recordServiceType(CxfPluginConstants.CXF_CLIENT_SERVICE_TYPE);
            recorder.recordDestinationId(destination);
            recorder.recordAttribute(CxfPluginConstants.CXF_ADDRESS, httpUri);
            recorder.recordAttribute(CxfPluginConstants.CXF_HTTP_METHOD, requestMethod);
            recorder.recordAttribute(CxfPluginConstants.CXF_CONTENT_TYPE, contentType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        Trace trace;
        if (this.logger.isDebugEnabled()) {
            this.logger.afterInterceptor(target, args);
        }
        if ((trace = this.traceContext.currentTraceObject()) == null) {
            return;
        }
        try {
            SpanEventRecorder recorder = trace.currentSpanEventRecorder();
            recorder.recordApi(this.descriptor);
            recorder.recordException(throwable);
        }
        finally {
            trace.traceBlockEnd();
        }
    }

    private String getDestination(Object[] args) {
        if (args[0] instanceof Map) {
            Map message = (Map)args[0];
            String address = (String)message.get("org.apache.cxf.message.Message.ENDPOINT_ADDRESS");
            try {
                URL url = new URL(address);
                return url.getProtocol() + "://" + url.getAuthority();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    private String getHttpUri(Object[] args) {
        if (args[0] instanceof Map) {
            Map message = (Map)args[0];
            String httpUri = (String)message.get("org.apache.cxf.request.uri");
            return httpUri != null ? httpUri : "unknown";
        }
        return "unknown";
    }

    private String getRequestMethod(Object[] args) {
        if (args[0] instanceof Map) {
            Map message = (Map)args[0];
            String requestMethod = (String)message.get("org.apache.cxf.request.method");
            return requestMethod != null ? requestMethod : "unknown";
        }
        return "unknown";
    }

    private String getContentType(Object[] args) {
        if (args[0] instanceof Map) {
            Map message = (Map)args[0];
            String contentType = (String)message.get("Content-Type");
            return contentType != null ? contentType : "unknown";
        }
        return "unknown";
    }
}

