/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.httpclient4.interceptor;

import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.SpanEventSimpleAroundInterceptorForPlugin;
import com.navercorp.pinpoint.common.trace.AnnotationKey;
import com.navercorp.pinpoint.plugin.httpclient4.EndPointUtils;
import com.navercorp.pinpoint.plugin.httpclient4.HttpClient4Constants;
import org.apache.http.conn.routing.HttpRoute;

public class HttpClientConnectionManagerConnectMethodInterceptor
extends SpanEventSimpleAroundInterceptorForPlugin {
    public HttpClientConnectionManagerConnectMethodInterceptor(TraceContext traceContext, MethodDescriptor methodDescriptor) {
        super(traceContext, methodDescriptor);
    }

    protected void doInBeforeTrace(SpanEventRecorder recorder, Object target, Object[] args) {
        if (args != null && args.length >= 2 && args[1] instanceof HttpRoute) {
            HttpRoute route = (HttpRoute)args[1];
            String hostAndPort = EndPointUtils.getHostAndPort(route);
            recorder.recordAttribute(AnnotationKey.HTTP_INTERNAL_DISPLAY, hostAndPort);
        }
        recorder.recordApi(this.methodDescriptor);
        recorder.recordServiceType(HttpClient4Constants.HTTP_CLIENT_4_INTERNAL);
    }

    protected void doInAfterTrace(SpanEventRecorder recorder, Object target, Object[] args, Object result, Throwable throwable) {
        recorder.recordException(throwable);
    }
}

