/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.cassandra;

import com.navercorp.pinpoint.bootstrap.instrument.InstrumentClass;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentException;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentMethod;
import com.navercorp.pinpoint.bootstrap.instrument.Instrumentor;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformCallback;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplate;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplateAware;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.ExecutionPolicy;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPlugin;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPluginSetupContext;
import com.navercorp.pinpoint.bootstrap.plugin.util.InstrumentUtils;
import com.navercorp.pinpoint.common.util.VarArgs;
import com.navercorp.pinpoint.plugin.cassandra.CassandraConfig;
import java.security.ProtectionDomain;

public class CassandraPlugin
implements ProfilerPlugin,
TransformTemplateAware {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private static final String CLASS_SESSION_MANAGER = "com.datastax.driver.core.SessionManager";
    private static final String CLASS_ABSTRACT_SESSION = "com.datastax.driver.core.AbstractSession";
    private TransformTemplate transformTemplate;

    public void setup(ProfilerPluginSetupContext context) {
        CassandraConfig config = new CassandraConfig(context.getConfig());
        if (!config.isPluginEnable()) {
            this.logger.info("Cassandra plugin is not executed because plugin enable value is false.");
            return;
        }
        this.addStatementWrapperTransformer();
        this.addDefaultPreparedStatementTransformer();
        this.addSessionTransformer(config);
        this.addClusterTransformer();
    }

    private void addStatementWrapperTransformer() {
        this.transformTemplate.transform("com.datastax.driver.core.StatementWrapper", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                target.addGetter("com.navercorp.pinpoint.plugin.cassandra.field.WrappedStatementGetter", "wrapped");
                return target.toBytecode();
            }
        });
    }

    private void addDefaultPreparedStatementTransformer() {
        TransformCallback transformer = new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                if (!target.isInterceptable()) {
                    return null;
                }
                target.addField("com.navercorp.pinpoint.bootstrap.plugin.jdbc.DatabaseInfoAccessor");
                target.addField("com.navercorp.pinpoint.bootstrap.plugin.jdbc.ParsingResultAccessor");
                target.addField("com.navercorp.pinpoint.bootstrap.plugin.jdbc.BindValueAccessor");
                return target.toBytecode();
            }
        };
        this.transformTemplate.transform("com.datastax.driver.core.DefaultPreparedStatement", transformer);
    }

    private void addSessionTransformer(final CassandraConfig config) {
        TransformCallback transformer = new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                if (!target.isInterceptable()) {
                    return null;
                }
                if (className.equals(CassandraPlugin.CLASS_SESSION_MANAGER) && instrumentor.exist(loader, CassandraPlugin.CLASS_ABSTRACT_SESSION, protectionDomain)) {
                    return null;
                }
                target.addField("com.navercorp.pinpoint.bootstrap.plugin.jdbc.DatabaseInfoAccessor");
                target.addField("com.navercorp.pinpoint.bootstrap.plugin.jdbc.ParsingResultAccessor");
                target.addField("com.navercorp.pinpoint.bootstrap.plugin.jdbc.BindValueAccessor");
                InstrumentMethod close = InstrumentUtils.findMethod((InstrumentClass)target, (String)"close", (String[])new String[0]);
                close.addScopedInterceptor("com.navercorp.pinpoint.plugin.cassandra.interceptor.CassandraConnectionCloseInterceptor", "CASSANDRA_CQL");
                InstrumentMethod prepare1 = InstrumentUtils.findMethod((InstrumentClass)target, (String)"prepare", (String[])new String[]{"java.lang.String"});
                prepare1.addScopedInterceptor("com.navercorp.pinpoint.plugin.cassandra.interceptor.CassandraPreparedStatementCreateInterceptor", "CASSANDRA_CQL");
                InstrumentMethod prepare2 = InstrumentUtils.findMethod((InstrumentClass)target, (String)"prepare", (String[])new String[]{"com.datastax.driver.core.RegularStatement"});
                prepare2.addScopedInterceptor("com.navercorp.pinpoint.plugin.cassandra.interceptor.CassandraPreparedStatementCreateInterceptor", "CASSANDRA_CQL");
                InstrumentMethod execute1 = InstrumentUtils.findMethod((InstrumentClass)target, (String)"execute", (String[])new String[]{"java.lang.String"});
                execute1.addScopedInterceptor("com.navercorp.pinpoint.plugin.cassandra.interceptor.CassandraStatementExecuteQueryInterceptor", VarArgs.va((Object[])new Object[]{config.getMaxSqlBindValueSize()}), "CASSANDRA_CQL");
                InstrumentMethod execute2 = InstrumentUtils.findMethod((InstrumentClass)target, (String)"execute", (String[])new String[]{"java.lang.String", "java.lang.Object[]"});
                execute2.addScopedInterceptor("com.navercorp.pinpoint.plugin.cassandra.interceptor.CassandraStatementExecuteQueryInterceptor", VarArgs.va((Object[])new Object[]{config.getMaxSqlBindValueSize()}), "CASSANDRA_CQL");
                InstrumentMethod execute3 = InstrumentUtils.findMethod((InstrumentClass)target, (String)"execute", (String[])new String[]{"com.datastax.driver.core.Statement"});
                execute3.addScopedInterceptor("com.navercorp.pinpoint.plugin.cassandra.interceptor.CassandraStatementExecuteQueryInterceptor", VarArgs.va((Object[])new Object[]{config.getMaxSqlBindValueSize()}), "CASSANDRA_CQL");
                return target.toBytecode();
            }
        };
        this.transformTemplate.transform(CLASS_SESSION_MANAGER, transformer);
        this.transformTemplate.transform(CLASS_ABSTRACT_SESSION, transformer);
    }

    private void addClusterTransformer() {
        this.transformTemplate.transform("com.datastax.driver.core.Cluster", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                if (!target.isInterceptable()) {
                    return null;
                }
                target.addField("com.navercorp.pinpoint.bootstrap.plugin.jdbc.DatabaseInfoAccessor");
                InstrumentMethod connect = InstrumentUtils.findMethod((InstrumentClass)target, (String)"connect", (String[])new String[]{"java.lang.String"});
                connect.addScopedInterceptor("com.navercorp.pinpoint.plugin.cassandra.interceptor.CassandraDriverConnectInterceptor", VarArgs.va((Object[])new Object[]{true}), "CASSANDRA_CQL", ExecutionPolicy.ALWAYS);
                InstrumentMethod close = InstrumentUtils.findMethod((InstrumentClass)target, (String)"close", (String[])new String[0]);
                close.addScopedInterceptor("com.navercorp.pinpoint.plugin.cassandra.interceptor.CassandraConnectionCloseInterceptor", "CASSANDRA_CQL");
                return target.toBytecode();
            }
        });
    }

    public void setTransformTemplate(TransformTemplate transformTemplate) {
        this.transformTemplate = transformTemplate;
    }
}

