/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.thrift.io;

import com.navercorp.pinpoint.thrift.io.BufferOverflowException;
import com.navercorp.pinpoint.thrift.io.ResettableByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Arrays;

public class UnsafeByteArrayOutputStream
extends ResettableByteArrayOutputStream {
    private static final String UTF8 = "UTF8";
    private static final Charset UTF8_CHARSET = Charset.forName("UTF8");
    private final boolean autoExpand;

    public UnsafeByteArrayOutputStream() {
        this(32);
    }

    public UnsafeByteArrayOutputStream(int size) {
        this(size, true);
    }

    public UnsafeByteArrayOutputStream(int size, boolean autoExpand) {
        super(size);
        this.autoExpand = autoExpand;
    }

    @Override
    public void write(int b) {
        int newcount = this.count + 1;
        if (this.isOverflow(newcount)) {
            if (this.autoExpand) {
                this.buf = Arrays.copyOf(this.buf, Math.max(this.buf.length << 1, newcount));
            } else {
                throw new BufferOverflowException("Buffer size cannot exceed " + this.buf.length + ". (now:" + this.count + ", input-size:1");
            }
        }
        this.buf[this.count] = (byte)b;
        this.count = newcount;
    }

    @Override
    public void write(byte[] b, int off, int len) {
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int newcount = this.count + len;
        if (this.isOverflow(newcount)) {
            if (this.autoExpand) {
                this.buf = Arrays.copyOf(this.buf, Math.max(this.buf.length << 1, newcount));
            } else {
                throw new BufferOverflowException("Buffer size cannot exceed " + this.buf.length + ". (now:" + this.count + ", input-size:" + len);
            }
        }
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count = newcount;
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        out.write(this.buf, 0, this.count);
    }

    @Override
    public void reset() {
        this.count = 0;
    }

    @Override
    public byte[] toByteArray() {
        return this.buf;
    }

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public String toString() {
        try {
            return this.toString(UTF8);
        }
        catch (UnsupportedEncodingException ex) {
            return new String(this.buf, 0, this.count, UTF8_CHARSET);
        }
    }

    @Override
    public String toString(String charsetName) throws UnsupportedEncodingException {
        return new String(this.buf, 0, this.count, charsetName);
    }

    @Override
    public void close() throws IOException {
    }

    private boolean isOverflow(int minCapacity) {
        return minCapacity - this.buf.length > 0;
    }
}

