/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.service;

import com.navercorp.pinpoint.common.service.AnnotationKeyRegistryService;
import com.navercorp.pinpoint.common.service.TraceMetadataLoaderService;
import com.navercorp.pinpoint.common.trace.AnnotationKey;
import com.navercorp.pinpoint.common.trace.AnnotationKeyRegistry;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.common.util.StaticFieldLookUp;
import com.navercorp.pinpoint.common.util.logger.CommonLogger;
import com.navercorp.pinpoint.common.util.logger.CommonLoggerFactory;
import java.util.List;

public class DefaultAnnotationKeyRegistryService
implements AnnotationKeyRegistryService {
    private final CommonLogger logger;
    private final TraceMetadataLoaderService typeLoaderService;
    private final AnnotationKeyRegistry registry;

    public DefaultAnnotationKeyRegistryService(TraceMetadataLoaderService typeLoaderService, CommonLoggerFactory commonLogger) {
        Assert.requireNonNull(commonLogger, "commonLogger must not be null");
        this.logger = commonLogger.getLogger(DefaultAnnotationKeyRegistryService.class.getName());
        this.typeLoaderService = Assert.requireNonNull(typeLoaderService, "typeLoaderService must not be null");
        this.registry = this.buildAnnotationKeyRegistry();
    }

    private AnnotationKeyRegistry buildAnnotationKeyRegistry() {
        AnnotationKeyRegistry.Builder builder = new AnnotationKeyRegistry.Builder();
        StaticFieldLookUp<AnnotationKey> staticFieldLookUp = new StaticFieldLookUp<AnnotationKey>(AnnotationKey.class, AnnotationKey.class);
        List<AnnotationKey> lookup = staticFieldLookUp.lookup();
        for (AnnotationKey serviceType : lookup) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("add Default AnnotationKey:" + serviceType);
            }
            builder.addAnnotationKey(serviceType);
        }
        List<AnnotationKey> types = this.typeLoaderService.getAnnotationKeys();
        for (AnnotationKey type : types) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("add Plugin AnnotationKey:" + type);
            }
            builder.addAnnotationKey(type);
        }
        return builder.build();
    }

    @Override
    public AnnotationKey findAnnotationKey(int annotationCode) {
        return this.registry.findAnnotationKey(annotationCode);
    }

    @Override
    public AnnotationKey findAnnotationKeyByName(String keyName) {
        return this.registry.findAnnotationKeyByName(keyName);
    }

    @Override
    public AnnotationKey findApiErrorCode(int annotationCode) {
        return this.registry.findApiErrorCode(annotationCode);
    }
}

