/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.objectfactory;

import com.navercorp.pinpoint.profiler.objectfactory.ArgumentsResolver;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class StaticMethodResolver {
    private final Class<?> type;
    private final String methodName;
    private final ArgumentsResolver argumentsResolver;
    private Method resolvedMethod;
    private Object[] resolvedArguments;
    private static final Comparator<Method> COMPARATOR = new Comparator<Method>(){

        @Override
        public int compare(Method o1, Method o2) {
            int p2;
            int p1 = o1.getParameterTypes().length;
            return p1 < (p2 = o2.getParameterTypes().length) ? 1 : (p1 == p2 ? 0 : -1);
        }
    };

    public StaticMethodResolver(Class<?> type, String methodName, ArgumentsResolver argumentsResolver) {
        this.type = type;
        this.methodName = methodName;
        this.argumentsResolver = argumentsResolver;
    }

    private List<Method> getCandidates() {
        ArrayList<Method> result = new ArrayList<Method>();
        for (Method method : this.type.getMethods()) {
            if (!Modifier.isStatic(method.getModifiers()) || !method.getName().equals(this.methodName)) continue;
            result.add(method);
        }
        Collections.sort(result, COMPARATOR);
        return result;
    }

    public boolean resolve() {
        List<Method> candidates = this.getCandidates();
        for (Method method : candidates) {
            Annotation[][] annotations;
            Class<?>[] types = method.getParameterTypes();
            Object[] arguments = this.argumentsResolver.resolve(types, annotations = method.getParameterAnnotations());
            if (arguments == null) continue;
            this.resolvedMethod = method;
            this.resolvedArguments = arguments;
            return true;
        }
        return false;
    }

    public Method getResolvedMethod() {
        return this.resolvedMethod;
    }

    public Object[] getResolvedArguments() {
        return this.resolvedArguments;
    }
}

