/*
 * Decompiled with CFR 0.152.
 */
package com.secnium.iast.thirdparty.org.apache.commons.configuration;

import com.secnium.iast.thirdparty.org.apache.commons.collections.ExtendedProperties;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.AbstractConfiguration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.Configuration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.ConfigurationMap;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.MapConfiguration;
import com.secnium.iast.thirdparty.org.apache.commons.lang.StringUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConfigurationConverter {
    private ConfigurationConverter() {
    }

    public static Configuration getConfiguration(ExtendedProperties extendedProperties) {
        return new MapConfiguration((Map<String, ?>)extendedProperties);
    }

    public static Configuration getConfiguration(Properties properties) {
        return new MapConfiguration(properties);
    }

    public static ExtendedProperties getExtendedProperties(Configuration configuration) {
        ExtendedProperties extendedProperties = new ExtendedProperties();
        Iterator<String> iterator = configuration.getKeys();
        while (iterator.hasNext()) {
            String string = iterator.next();
            ArrayList arrayList = configuration.getProperty(string);
            if (arrayList instanceof List) {
                arrayList = new ArrayList(arrayList);
            }
            extendedProperties.setProperty(string, (Object)arrayList);
        }
        return extendedProperties;
    }

    public static Properties getProperties(Configuration configuration) {
        Properties properties = new Properties();
        char c2 = configuration instanceof AbstractConfiguration ? (char)((AbstractConfiguration)configuration).getListDelimiter() : (char)',';
        Iterator<String> iterator = configuration.getKeys();
        while (iterator.hasNext()) {
            String string = iterator.next();
            List<Object> list = configuration.getList(string);
            properties.setProperty(string, StringUtils.join(list.iterator(), c2));
        }
        return properties;
    }

    public static Map<Object, Object> getMap(Configuration configuration) {
        return new ConfigurationMap(configuration);
    }
}

