/*
 * Decompiled with CFR 0.152.
 */
package com.secnium.iast.thirdparty.org.apache.commons.cli;

import com.secnium.iast.thirdparty.org.apache.commons.cli.Option;
import com.secnium.iast.thirdparty.org.apache.commons.cli.ParseException;
import com.secnium.iast.thirdparty.org.apache.commons.cli.TypeHandler;
import com.secnium.iast.thirdparty.org.apache.commons.cli.Util;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLine
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<String> args = new LinkedList<String>();
    private final List<Option> options = new ArrayList<Option>();

    protected CommandLine() {
    }

    public boolean hasOption(String string) {
        return this.options.contains(this.resolveOption(string));
    }

    public boolean hasOption(char c2) {
        return this.hasOption(String.valueOf(c2));
    }

    @Deprecated
    public Object getOptionObject(String string) {
        try {
            return this.getParsedOptionValue(string);
        }
        catch (ParseException parseException) {
            System.err.println("Exception found converting " + string + " to desired type: " + parseException.getMessage());
            return null;
        }
    }

    public Object getParsedOptionValue(String string) throws ParseException {
        String string2 = this.getOptionValue(string);
        Option option = this.resolveOption(string);
        if (option == null || string2 == null) {
            return null;
        }
        return TypeHandler.createValue(string2, option.getType());
    }

    public Object getOptionObject(char c2) {
        return this.getOptionObject(String.valueOf(c2));
    }

    public String getOptionValue(String string) {
        String[] stringArray = this.getOptionValues(string);
        return stringArray == null ? null : stringArray[0];
    }

    public String getOptionValue(char c2) {
        return this.getOptionValue(String.valueOf(c2));
    }

    public String[] getOptionValues(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Option option : this.options) {
            if (!string.equals(option.getOpt()) && !string.equals(option.getLongOpt())) continue;
            arrayList.addAll(option.getValuesList());
        }
        return arrayList.isEmpty() ? null : arrayList.toArray(new String[arrayList.size()]);
    }

    private Option resolveOption(String string) {
        string = Util.stripLeadingHyphens(string);
        for (Option option : this.options) {
            if (string.equals(option.getOpt())) {
                return option;
            }
            if (!string.equals(option.getLongOpt())) continue;
            return option;
        }
        return null;
    }

    public String[] getOptionValues(char c2) {
        return this.getOptionValues(String.valueOf(c2));
    }

    public String getOptionValue(String string, String string2) {
        String string3 = this.getOptionValue(string);
        return string3 != null ? string3 : string2;
    }

    public String getOptionValue(char c2, String string) {
        return this.getOptionValue(String.valueOf(c2), string);
    }

    public Properties getOptionProperties(String string) {
        Properties properties = new Properties();
        for (Option option : this.options) {
            if (!string.equals(option.getOpt()) && !string.equals(option.getLongOpt())) continue;
            List<String> list = option.getValuesList();
            if (list.size() >= 2) {
                properties.put(list.get(0), list.get(1));
                continue;
            }
            if (list.size() != 1) continue;
            properties.put(list.get(0), "true");
        }
        return properties;
    }

    public String[] getArgs() {
        String[] stringArray = new String[this.args.size()];
        this.args.toArray(stringArray);
        return stringArray;
    }

    public List<String> getArgList() {
        return this.args;
    }

    protected void addArg(String string) {
        this.args.add(string);
    }

    protected void addOption(Option option) {
        this.options.add(option);
    }

    public Iterator<Option> iterator() {
        return this.options.iterator();
    }

    public Option[] getOptions() {
        List<Option> list = this.options;
        Option[] optionArray = new Option[list.size()];
        return list.toArray(optionArray);
    }

    public static final class Builder {
        private final CommandLine commandLine = new CommandLine();

        public Builder addOption(Option option) {
            this.commandLine.addOption(option);
            return this;
        }

        public Builder addArg(String string) {
            this.commandLine.addArg(string);
            return this;
        }

        public CommandLine build() {
            return this.commandLine;
        }
    }
}

