/*
 * Decompiled with CFR 0.152.
 */
package com.secnium.iast.thirdparty.org.apache.commons.configuration;

import com.secnium.iast.thirdparty.org.apache.commons.configuration.AbstractConfiguration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.BaseConfiguration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.Configuration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.ConfigurationRuntimeException;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.ConfigurationUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeConfiguration
extends AbstractConfiguration
implements Cloneable {
    private List<Configuration> configList = new LinkedList<Configuration>();
    private Configuration inMemoryConfiguration;
    private boolean inMemoryConfigIsChild;

    public CompositeConfiguration() {
        this.clear();
    }

    public CompositeConfiguration(Configuration configuration) {
        this.configList.clear();
        this.inMemoryConfiguration = configuration;
        this.configList.add(configuration);
    }

    public CompositeConfiguration(Collection<? extends Configuration> collection) {
        this(new BaseConfiguration(), collection);
    }

    public CompositeConfiguration(Configuration configuration, Collection<? extends Configuration> collection) {
        this(configuration);
        if (collection != null) {
            for (Configuration configuration2 : collection) {
                this.addConfiguration(configuration2);
            }
        }
    }

    public void addConfiguration(Configuration configuration) {
        this.addConfiguration(configuration, false);
    }

    public void addConfiguration(Configuration configuration, boolean bl) {
        if (!this.configList.contains(configuration)) {
            if (bl) {
                this.replaceInMemoryConfiguration(configuration);
                this.inMemoryConfigIsChild = true;
            }
            if (!this.inMemoryConfigIsChild) {
                this.configList.add(this.configList.indexOf(this.inMemoryConfiguration), configuration);
            } else {
                this.configList.add(configuration);
            }
            if (configuration instanceof AbstractConfiguration) {
                ((AbstractConfiguration)configuration).setThrowExceptionOnMissing(this.isThrowExceptionOnMissing());
            }
        }
    }

    public void removeConfiguration(Configuration configuration) {
        if (!configuration.equals(this.inMemoryConfiguration)) {
            this.configList.remove(configuration);
        }
    }

    public int getNumberOfConfigurations() {
        return this.configList.size();
    }

    @Override
    public void clear() {
        this.configList.clear();
        this.inMemoryConfiguration = new BaseConfiguration();
        ((BaseConfiguration)this.inMemoryConfiguration).setThrowExceptionOnMissing(this.isThrowExceptionOnMissing());
        ((BaseConfiguration)this.inMemoryConfiguration).setListDelimiter(this.getListDelimiter());
        ((BaseConfiguration)this.inMemoryConfiguration).setDelimiterParsingDisabled(this.isDelimiterParsingDisabled());
        this.configList.add(this.inMemoryConfiguration);
        this.inMemoryConfigIsChild = false;
    }

    @Override
    protected void addPropertyDirect(String string, Object object) {
        this.inMemoryConfiguration.addProperty(string, object);
    }

    @Override
    public Object getProperty(String string) {
        Configuration configuration = null;
        for (Configuration configuration2 : this.configList) {
            if (!configuration2.containsKey(string)) continue;
            configuration = configuration2;
            break;
        }
        if (configuration != null) {
            return configuration.getProperty(string);
        }
        return null;
    }

    @Override
    public Iterator<String> getKeys() {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (Configuration configuration : this.configList) {
            Iterator<String> iterator = configuration.getKeys();
            while (iterator.hasNext()) {
                linkedHashSet.add(iterator.next());
            }
        }
        return linkedHashSet.iterator();
    }

    @Override
    public Iterator<String> getKeys(String string) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (Configuration configuration : this.configList) {
            Iterator<String> iterator = configuration.getKeys(string);
            while (iterator.hasNext()) {
                linkedHashSet.add(iterator.next());
            }
        }
        return linkedHashSet.iterator();
    }

    @Override
    public boolean isEmpty() {
        for (Configuration configuration : this.configList) {
            if (configuration.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void clearPropertyDirect(String string) {
        for (Configuration configuration : this.configList) {
            configuration.clearProperty(string);
        }
    }

    @Override
    public boolean containsKey(String string) {
        for (Configuration configuration : this.configList) {
            if (!configuration.containsKey(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Object> getList(String string, List<?> list) {
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator<Configuration> iterator = this.configList.iterator();
        while (iterator.hasNext() && arrayList.isEmpty()) {
            object = iterator.next();
            if (object == this.inMemoryConfiguration || !object.containsKey(string)) continue;
            CompositeConfiguration.appendListProperty(arrayList, (Configuration)object, string);
        }
        CompositeConfiguration.appendListProperty(arrayList, this.inMemoryConfiguration, string);
        if (arrayList.isEmpty()) {
            return list;
        }
        object = arrayList.listIterator();
        while (object.hasNext()) {
            object.set(this.interpolate(object.next()));
        }
        return arrayList;
    }

    @Override
    public String[] getStringArray(String string) {
        List<Object> list = this.getList(string);
        String[] stringArray = new String[list.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = String.valueOf(list.get(i));
        }
        return stringArray;
    }

    public Configuration getConfiguration(int n) {
        return this.configList.get(n);
    }

    public Configuration getInMemoryConfiguration() {
        return this.inMemoryConfiguration;
    }

    @Override
    public Object clone() {
        try {
            CompositeConfiguration compositeConfiguration = (CompositeConfiguration)super.clone();
            compositeConfiguration.clearConfigurationListeners();
            compositeConfiguration.configList = new LinkedList<Configuration>();
            compositeConfiguration.inMemoryConfiguration = ConfigurationUtils.cloneConfiguration(this.getInMemoryConfiguration());
            compositeConfiguration.configList.add(compositeConfiguration.inMemoryConfiguration);
            for (Configuration configuration : this.configList) {
                if (configuration == this.getInMemoryConfiguration()) continue;
                compositeConfiguration.addConfiguration(ConfigurationUtils.cloneConfiguration(configuration));
            }
            return compositeConfiguration;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new ConfigurationRuntimeException(cloneNotSupportedException);
        }
    }

    @Override
    public void setDelimiterParsingDisabled(boolean bl) {
        if (this.inMemoryConfiguration instanceof AbstractConfiguration) {
            ((AbstractConfiguration)this.inMemoryConfiguration).setDelimiterParsingDisabled(bl);
        }
        super.setDelimiterParsingDisabled(bl);
    }

    @Override
    public void setListDelimiter(char c2) {
        if (this.inMemoryConfiguration instanceof AbstractConfiguration) {
            ((AbstractConfiguration)this.inMemoryConfiguration).setListDelimiter(c2);
        }
        super.setListDelimiter(c2);
    }

    public Configuration getSource(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Key must not be null!");
        }
        Configuration configuration = null;
        for (Configuration configuration2 : this.configList) {
            if (!configuration2.containsKey(string)) continue;
            if (configuration != null) {
                throw new IllegalArgumentException("The key " + string + " is defined by multiple sources!");
            }
            configuration = configuration2;
        }
        return configuration;
    }

    private void replaceInMemoryConfiguration(Configuration configuration) {
        if (!this.inMemoryConfigIsChild) {
            this.configList.remove(this.inMemoryConfiguration);
        }
        this.inMemoryConfiguration = configuration;
    }

    private static void appendListProperty(List<Object> list, Configuration configuration, String string) {
        Object object = configuration.getProperty(string);
        if (object != null) {
            if (object instanceof Collection) {
                Collection collection = (Collection)object;
                list.addAll(collection);
            } else {
                list.add(object);
            }
        }
    }
}

