/*
 * Decompiled with CFR 0.152.
 */
package com.secnium.iast.thirdparty.org.apache.commons.configuration;

import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PrefixedKeysIterator
implements Iterator<String> {
    private final Iterator<String> iterator;
    private final String prefix;
    private String nextElement;
    private boolean nextElementSet;

    public PrefixedKeysIterator(Iterator<String> iterator, String string) {
        this.iterator = iterator;
        this.prefix = string;
    }

    @Override
    public boolean hasNext() {
        return this.nextElementSet || this.setNextElement();
    }

    @Override
    public String next() {
        if (!this.nextElementSet && !this.setNextElement()) {
            throw new NoSuchElementException();
        }
        this.nextElementSet = false;
        return this.nextElement;
    }

    @Override
    public void remove() {
        if (this.nextElementSet) {
            throw new IllegalStateException("remove() cannot be called");
        }
        this.iterator.remove();
    }

    private boolean setNextElement() {
        while (this.iterator.hasNext()) {
            String string = this.iterator.next();
            if (!string.startsWith(this.prefix + ".") && !string.equals(this.prefix)) continue;
            this.nextElement = string;
            this.nextElementSet = true;
            return true;
        }
        return false;
    }
}

