/*
 * Decompiled with CFR 0.152.
 */
package com.secnium.iast.thirdparty.org.apache.commons.configuration;

import com.secnium.iast.thirdparty.org.apache.commons.configuration.AbstractFileConfiguration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.Configuration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.ConfigurationException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class INIConfiguration
extends AbstractFileConfiguration {
    protected static final String COMMENT_CHARS = "#;";
    protected static final String SEPARATOR_CHARS = "=:";

    public INIConfiguration() {
    }

    public INIConfiguration(String string) throws ConfigurationException {
        super(string);
    }

    public INIConfiguration(File file) throws ConfigurationException {
        super(file);
    }

    public INIConfiguration(URL uRL) throws ConfigurationException {
        super(uRL);
    }

    @Override
    public void save(Writer writer) throws ConfigurationException {
        PrintWriter printWriter = new PrintWriter(writer);
        for (String string : this.getSections()) {
            printWriter.print("[");
            printWriter.print(string);
            printWriter.print("]");
            printWriter.println();
            Configuration configuration = this.subset(string);
            Iterator<String> iterator = configuration.getKeys();
            while (iterator.hasNext()) {
                String string2 = iterator.next();
                Object object2 = configuration.getProperty(string2);
                if (object2 instanceof Collection) {
                    for (Object object2 : (Collection)object2) {
                        printWriter.print(string2);
                        printWriter.print(" = ");
                        printWriter.print(this.formatValue(object2.toString()));
                        printWriter.println();
                    }
                    continue;
                }
                printWriter.print(string2);
                printWriter.print(" = ");
                printWriter.print(this.formatValue(object2.toString()));
                printWriter.println();
            }
            printWriter.println();
        }
        printWriter.flush();
    }

    @Override
    public void load(Reader reader) throws ConfigurationException {
        try {
            BufferedReader bufferedReader = new BufferedReader(reader);
            String string = bufferedReader.readLine();
            String string2 = "";
            while (string != null) {
                if (!this.isCommentLine(string = string.trim())) {
                    if (this.isSectionLine(string)) {
                        string2 = string.substring(1, string.length() - 1) + ".";
                    } else {
                        String string3 = "";
                        String string4 = "";
                        int n = string.indexOf("=");
                        if (n >= 0) {
                            string3 = string2 + string.substring(0, n);
                            string4 = this.parseValue(string.substring(n + 1));
                        } else {
                            n = string.indexOf(":");
                            if (n >= 0) {
                                string3 = string2 + string.substring(0, n);
                                string4 = this.parseValue(string.substring(n + 1));
                            } else {
                                string3 = string2 + string;
                            }
                        }
                        this.addProperty(string3.trim(), string4);
                    }
                }
                string = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            throw new ConfigurationException("Unable to load the configuration", iOException);
        }
    }

    private String parseValue(String string) {
        boolean bl = (string = string.trim()).startsWith("\"") || string.startsWith("'");
        boolean bl2 = false;
        boolean bl3 = false;
        char c2 = bl ? string.charAt(0) : (char)'\u0000';
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = bl ? 1 : 0; i < string.length() && !bl2; ++i) {
            char c3 = string.charAt(i);
            if (bl) {
                if ('\\' == c3 && !bl3) {
                    bl3 = true;
                    continue;
                }
                if (!bl3 && c2 == c3) {
                    bl2 = true;
                    continue;
                }
                if (bl3 && c2 == c3) {
                    bl3 = false;
                    stringBuilder.append(c3);
                    continue;
                }
                if (bl3) {
                    bl3 = false;
                    stringBuilder.append('\\');
                }
                stringBuilder.append(c3);
                continue;
            }
            if (COMMENT_CHARS.indexOf(c3) == -1) {
                stringBuilder.append(c3);
                continue;
            }
            bl2 = true;
        }
        String string2 = stringBuilder.toString();
        if (!bl) {
            string2 = string2.trim();
        }
        return string2;
    }

    private String formatValue(String string) {
        boolean bl = false;
        for (int i = 0; i < COMMENT_CHARS.length() && !bl; ++i) {
            char c2 = COMMENT_CHARS.charAt(i);
            if (string.indexOf(c2) == -1) continue;
            bl = true;
        }
        if (bl) {
            return '\"' + string.replaceAll("\"", "\\\\\\\"") + '\"';
        }
        return string;
    }

    protected boolean isCommentLine(String string) {
        if (string == null) {
            return false;
        }
        return string.length() < 1 || COMMENT_CHARS.indexOf(string.charAt(0)) >= 0;
    }

    protected boolean isSectionLine(String string) {
        if (string == null) {
            return false;
        }
        return string.startsWith("[") && string.endsWith("]");
    }

    public Set<String> getSections() {
        TreeSet<String> treeSet = new TreeSet<String>();
        Iterator<String> iterator = this.getKeys();
        while (iterator.hasNext()) {
            String string = iterator.next();
            int n = string.indexOf(".");
            if (n < 0) continue;
            treeSet.add(string.substring(0, n));
        }
        return treeSet;
    }
}

