/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.thrift.io;

import com.navercorp.pinpoint.io.header.ByteArrayHeaderReader;
import com.navercorp.pinpoint.io.header.Header;
import com.navercorp.pinpoint.io.header.HeaderEntity;
import com.navercorp.pinpoint.io.header.HeaderReader;
import com.navercorp.pinpoint.io.header.InvalidHeaderException;
import com.navercorp.pinpoint.io.request.DefaultMessage;
import com.navercorp.pinpoint.io.request.Message;
import com.navercorp.pinpoint.io.util.TypeLocator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TMemoryInputTransport;
import org.apache.thrift.transport.TTransport;

public class ChunkHeaderTBaseDeserializer {
    private final TProtocol protocol;
    private final TMemoryInputTransport trans = new TMemoryInputTransport();
    private final TypeLocator<TBase<?, ?>> locator;

    ChunkHeaderTBaseDeserializer(TProtocolFactory protocolFactory, TypeLocator<TBase<?, ?>> locator) {
        this.protocol = protocolFactory.getProtocol((TTransport)this.trans);
        this.locator = locator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Message<TBase<?, ?>>> deserialize(byte[] bytes, int offset, int length) throws TException {
        try {
            this.trans.reset(bytes, offset, length);
            Header header = this.readHeader();
            if (this.locator.isSupport(header.getType())) {
                Object request2;
                ArrayList<Object> list = new ArrayList<Object>();
                while (this.trans.getBytesRemainingInBuffer() > 0) {
                    request2 = this.readInternal();
                    list.add(request2);
                }
                request2 = list;
                return request2;
            }
            Message<TBase<?, ?>> request = this.readInternal();
            if (request == null) {
                List<Message<TBase<?, ?>>> request2 = Collections.emptyList();
                return request2;
            }
            ArrayList list = new ArrayList();
            list.add(request);
            ArrayList arrayList = list;
            return arrayList;
        }
        finally {
            this.trans.clear();
            this.protocol.reset();
        }
    }

    private Message<TBase<?, ?>> readInternal() throws TException {
        ByteArrayHeaderReader reader = this.newHeaderReader();
        Header header = this.readHeader(reader);
        HeaderEntity headerEntity = this.readHeaderEntity(reader, header);
        this.skipHeaderOffset(reader);
        TBase<?, ?> base = this.locator.bodyLookup(header.getType());
        if (base == null) {
            throw new TException("base must not be null type:" + header.getType());
        }
        base.read(this.protocol);
        return new DefaultMessage(header, headerEntity, base);
    }

    private Header readHeader() throws TException {
        ByteArrayHeaderReader reader = this.newHeaderReader();
        Header header = this.readHeader(reader);
        this.skipHeaderOffset(reader);
        return header;
    }

    private void skipHeaderOffset(HeaderReader reader) {
        this.trans.reset(this.trans.getBuffer(), reader.getOffset(), reader.getRemaining());
    }

    private ByteArrayHeaderReader newHeaderReader() {
        byte[] buffer = this.trans.getBuffer();
        int bufferPosition = this.trans.getBufferPosition();
        int bytesRemainingInBuffer = this.trans.getBytesRemainingInBuffer();
        return new ByteArrayHeaderReader(buffer, bufferPosition, bytesRemainingInBuffer);
    }

    private Header readHeader(HeaderReader reader) throws TException {
        try {
            return reader.readHeader();
        }
        catch (InvalidHeaderException e) {
            throw new TException("invalid header Caused by:" + e.getMessage(), (Throwable)e);
        }
    }

    private HeaderEntity readHeaderEntity(HeaderReader reader, Header header) throws TException {
        try {
            return reader.readHeaderEntity(header);
        }
        catch (InvalidHeaderException e) {
            throw new TException("invalid headerEntity Caused by:" + e.getMessage(), (Throwable)e);
        }
    }
}

