/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.thrift;

import com.navercorp.pinpoint.common.Charsets;
import com.navercorp.pinpoint.plugin.thrift.ThriftHeader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.EnumMap;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;

public class ThriftRequestProperty {
    private EnumMap<ThriftHeader, Object> thriftHeaders = new EnumMap(ThriftHeader.class);
    private static final Charset HEADER_CHARSET_ENCODING = Charsets.UTF_8;

    public String getTraceId() {
        return this.getTraceId(null);
    }

    public String getTraceId(String defaultValue) {
        if (this.thriftHeaders.containsKey((Object)ThriftHeader.THRIFT_TRACE_ID)) {
            return (String)this.thriftHeaders.get((Object)ThriftHeader.THRIFT_TRACE_ID);
        }
        return defaultValue;
    }

    public void setTraceId(String traceId) {
        this.thriftHeaders.put(ThriftHeader.THRIFT_TRACE_ID, (Object)traceId);
    }

    public Long getSpanId() {
        return this.getSpanId(null);
    }

    public Long getSpanId(Long defaultValue) {
        if (this.thriftHeaders.containsKey((Object)ThriftHeader.THRIFT_SPAN_ID)) {
            return (Long)this.thriftHeaders.get((Object)ThriftHeader.THRIFT_SPAN_ID);
        }
        return defaultValue;
    }

    public void setSpanId(Long spanId) {
        this.thriftHeaders.put(ThriftHeader.THRIFT_SPAN_ID, (Object)spanId);
    }

    public Long getParentSpanId() {
        return this.getParentSpanId(null);
    }

    public Long getParentSpanId(Long defaultValue) {
        if (this.thriftHeaders.containsKey((Object)ThriftHeader.THRIFT_PARENT_SPAN_ID)) {
            return (Long)this.thriftHeaders.get((Object)ThriftHeader.THRIFT_PARENT_SPAN_ID);
        }
        return defaultValue;
    }

    public void setParentSpanId(Long parentSpanId) {
        this.thriftHeaders.put(ThriftHeader.THRIFT_PARENT_SPAN_ID, (Object)parentSpanId);
    }

    public Boolean shouldSample() {
        return this.shouldSample(null);
    }

    public Boolean shouldSample(Boolean defaultValue) {
        if (this.thriftHeaders.containsKey((Object)ThriftHeader.THRFIT_SAMPLED)) {
            return (Boolean)this.thriftHeaders.get((Object)ThriftHeader.THRFIT_SAMPLED);
        }
        return defaultValue;
    }

    public void setShouldSample(Boolean shouldSample) {
        this.thriftHeaders.put(ThriftHeader.THRFIT_SAMPLED, (Object)shouldSample);
    }

    public Short getFlags() {
        return this.getFlags(null);
    }

    public Short getFlags(Short defaultValue) {
        if (this.thriftHeaders.containsKey((Object)ThriftHeader.THRIFT_FLAGS)) {
            return (Short)this.thriftHeaders.get((Object)ThriftHeader.THRIFT_FLAGS);
        }
        return defaultValue;
    }

    public void setFlags(Short flags) {
        this.thriftHeaders.put(ThriftHeader.THRIFT_FLAGS, (Object)flags);
    }

    public String getParentApplicationName() {
        return this.getParentApplicationName(null);
    }

    public String getParentApplicationName(String defaultValue) {
        if (this.thriftHeaders.containsKey((Object)ThriftHeader.THRIFT_PARENT_APPLICATION_NAME)) {
            return (String)this.thriftHeaders.get((Object)ThriftHeader.THRIFT_PARENT_APPLICATION_NAME);
        }
        return defaultValue;
    }

    public void setParentApplicationName(String parentApplicationName) {
        this.thriftHeaders.put(ThriftHeader.THRIFT_PARENT_APPLICATION_NAME, (Object)parentApplicationName);
    }

    public Short getParentApplicationType() {
        return this.getParentApplicationType(null);
    }

    public Short getParentApplicationType(Short defaultValue) {
        if (this.thriftHeaders.containsKey((Object)ThriftHeader.THRIFT_PARENT_APPLICATION_TYPE)) {
            return (Short)this.thriftHeaders.get((Object)ThriftHeader.THRIFT_PARENT_APPLICATION_TYPE);
        }
        return defaultValue;
    }

    public void setParentApplicationType(Short parentApplicationType) {
        this.thriftHeaders.put(ThriftHeader.THRIFT_PARENT_APPLICATION_TYPE, (Object)parentApplicationType);
    }

    public String getAcceptorHost() {
        return this.getAcceptorHost("Unknown");
    }

    public String getAcceptorHost(String acceptorHost) {
        if (this.thriftHeaders.containsKey((Object)ThriftHeader.THRIFT_HOST)) {
            return (String)this.thriftHeaders.get((Object)ThriftHeader.THRIFT_HOST);
        }
        return acceptorHost;
    }

    public void setAcceptorHost(String acceptorHost) {
        this.thriftHeaders.put(ThriftHeader.THRIFT_HOST, (Object)acceptorHost);
    }

    public void setTraceHeader(ThriftHeader headerKey, Object value) throws TException {
        byte headerType = headerKey.getType();
        if (headerType == 11) {
            this.thriftHeaders.put(headerKey, (Object)ThriftRequestProperty.byteBufferToString((ByteBuffer)value));
        } else if (headerType == 10) {
            this.thriftHeaders.put(headerKey, (Object)((Long)value));
        } else if (headerType == 6) {
            this.thriftHeaders.put(headerKey, (Object)((Short)value));
        } else if (headerType == 2) {
            this.thriftHeaders.put(headerKey, (Object)((Boolean)value));
        } else {
            throw new TProtocolException("Invalid pinpoint header type - " + headerType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTraceHeader(ThriftHeader headerKey, TProtocol oprot) throws TException {
        block8: {
            Object headerValue = this.thriftHeaders.get((Object)headerKey);
            if (headerValue == null) {
                return;
            }
            byte headerType = headerKey.getType();
            TField traceField = new TField(headerKey.name(), headerKey.getType(), headerKey.getId());
            oprot.writeFieldBegin(traceField);
            try {
                if (headerType == 11) {
                    oprot.writeBinary(ThriftRequestProperty.stringToByteBuffer((String)headerValue));
                    break block8;
                }
                if (headerType == 10) {
                    oprot.writeI64(((Long)headerValue).longValue());
                    break block8;
                }
                if (headerType == 6) {
                    oprot.writeI16(((Short)headerValue).shortValue());
                    break block8;
                }
                if (headerType == 2) {
                    oprot.writeBool(((Boolean)headerValue).booleanValue());
                    break block8;
                }
                throw new TProtocolException("Invalid pinpoint header type - " + headerType);
            }
            finally {
                oprot.writeFieldEnd();
            }
        }
    }

    private static ByteBuffer stringToByteBuffer(String s) {
        return ByteBuffer.wrap(s.getBytes(HEADER_CHARSET_ENCODING));
    }

    private static String byteBufferToString(ByteBuffer buf) {
        CharBuffer charBuffer = HEADER_CHARSET_ENCODING.decode(buf);
        return charBuffer.toString();
    }

    public String toString() {
        return this.thriftHeaders.toString();
    }
}

