/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.instrument;

import com.navercorp.pinpoint.bootstrap.instrument.InstrumentException;
import com.navercorp.pinpoint.bootstrap.instrument.aspect.Aspect;
import com.navercorp.pinpoint.bootstrap.instrument.aspect.JointPoint;
import com.navercorp.pinpoint.bootstrap.instrument.aspect.PointCut;
import com.navercorp.pinpoint.profiler.instrument.ASMClassNodeAdapter;
import com.navercorp.pinpoint.profiler.instrument.ASMMethodInsnNodeRemapper;
import com.navercorp.pinpoint.profiler.instrument.ASMMethodNodeAdapter;
import com.navercorp.pinpoint.profiler.instrument.DefaultMethodNameReplacer;
import com.navercorp.pinpoint.profiler.instrument.MethodNameReplacer;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ASMAspectWeaver {
    private static final MethodNameReplacer DEFAULT_METHOD_NAME_REPLACER = new DefaultMethodNameReplacer();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final MethodNameReplacer methodNameReplacer;

    public ASMAspectWeaver() {
        this(DEFAULT_METHOD_NAME_REPLACER);
    }

    public ASMAspectWeaver(MethodNameReplacer methodNameReplacer) {
        this.methodNameReplacer = methodNameReplacer;
    }

    public void weaving(ASMClassNodeAdapter sourceClassNode, ASMClassNodeAdapter adviceClassNode) throws InstrumentException {
        String superClassInternalName;
        if (sourceClassNode == null || adviceClassNode == null) {
            throw new InstrumentException("source and advice class node must not be null.");
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("weaving sourceClass={} adviceClass={}", (Object)sourceClassNode.getInternalName(), (Object)adviceClassNode.getInternalName());
        }
        if (!adviceClassNode.hasAnnotation(Aspect.class)) {
            throw new InstrumentException("@Aspect not found. adviceClass=" + adviceClassNode.getInternalName());
        }
        boolean isSubclass = adviceClassNode.subclassOf(sourceClassNode.getInternalName());
        if (!(isSubclass || (superClassInternalName = adviceClassNode.getSuperClassInternalName()) != null && superClassInternalName.equals("java/lang/Object"))) {
            throw new InstrumentException("invalid class hierarchy. source class=" + sourceClassNode.getInternalName() + ", advice class=" + adviceClassNode.getInternalName() + ", super class=" + superClassInternalName);
        }
        MethodNodes methodNodes = this.findMethodNodes(adviceClassNode);
        this.copyUtilMethods(methodNodes, sourceClassNode);
        this.copyPointCutMethods(methodNodes, sourceClassNode);
    }

    private MethodNodes findMethodNodes(ASMClassNodeAdapter adviceClassNode) {
        MethodNodes methodNodes = new MethodNodes();
        for (ASMMethodNodeAdapter methodNode : adviceClassNode.getDeclaredMethods()) {
            if (methodNode.hasAnnotation(PointCut.class)) {
                methodNodes.pointCuts.add(methodNode);
                continue;
            }
            if (methodNode.hasAnnotation(JointPoint.class)) {
                methodNodes.jointPoints.add(methodNode);
                continue;
            }
            methodNodes.utils.add(methodNode);
        }
        return methodNodes;
    }

    private void copyUtilMethods(MethodNodes methodNodes, ASMClassNodeAdapter classNode) throws InstrumentException {
        for (ASMMethodNodeAdapter methodNode : methodNodes.utils) {
            if (!methodNode.isPrivate()) {
                throw new InstrumentException("non private UtilMethod unsupported. method=" + methodNode.getLongName());
            }
            classNode.copyMethod(methodNode);
        }
    }

    private void copyPointCutMethods(MethodNodes methodNodes, ASMClassNodeAdapter classNode) throws InstrumentException {
        ASMMethodInsnNodeRemapper.Builder remapBuilder = new ASMMethodInsnNodeRemapper.Builder();
        for (ASMMethodNodeAdapter joinPointMethodNode : methodNodes.jointPoints) {
            remapBuilder.addFilter(null, joinPointMethodNode.getName(), joinPointMethodNode.getDesc());
        }
        for (ASMMethodNodeAdapter pointCutMethodNode : methodNodes.pointCuts) {
            ASMMethodNodeAdapter sourceMethodNode = classNode.getDeclaredMethod(pointCutMethodNode.getName(), pointCutMethodNode.getDesc());
            if (sourceMethodNode == null) {
                throw new InstrumentException("not found method. " + classNode.getInternalName() + "." + pointCutMethodNode.getName());
            }
            if (!sourceMethodNode.getDesc().equals(pointCutMethodNode.getDesc())) {
                throw new InstrumentException("Signature miss match. method=" + pointCutMethodNode.getName() + ", source=" + sourceMethodNode.getDesc() + ", advice=" + pointCutMethodNode.getDesc());
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info("weaving method={}{}", (Object)sourceMethodNode.getName(), (Object)sourceMethodNode.getDesc());
            }
            String methodName = this.methodNameReplacer.replaceMethodName(sourceMethodNode.getName());
            sourceMethodNode.rename(methodName);
            sourceMethodNode.setAccess(sourceMethodNode.getAccess() & 0xFFFFFFFA | 2);
            classNode.copyMethod(pointCutMethodNode);
            ASMMethodNodeAdapter newMethodNode = classNode.getDeclaredMethod(pointCutMethodNode.getName(), pointCutMethodNode.getDesc());
            if (newMethodNode == null) {
                throw new InstrumentException("not found new method. " + classNode.getInternalName() + "." + pointCutMethodNode.getName());
            }
            remapBuilder.setName(methodName);
            ASMMethodInsnNodeRemapper remapper = remapBuilder.build();
            newMethodNode.remapMethodInsnNode(remapper);
        }
    }

    private static class MethodNodes {
        public final List<ASMMethodNodeAdapter> pointCuts = new ArrayList<ASMMethodNodeAdapter>();
        public final List<ASMMethodNodeAdapter> jointPoints = new ArrayList<ASMMethodNodeAdapter>();
        public final List<ASMMethodNodeAdapter> utils = new ArrayList<ASMMethodNodeAdapter>();

        private MethodNodes() {
        }
    }
}

