/*
 * Decompiled with CFR 0.152.
 */
package com.secnium.iast.thirdparty.org.apache.commons.configuration.reloading;

import com.secnium.iast.thirdparty.org.apache.commons.configuration.ConfigurationRuntimeException;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.FileConfiguration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.FileSystem;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.FileSystemBased;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.reloading.ReloadingStrategy;
import com.secnium.iast.thirdparty.org.apache.commons.logging.Log;
import com.secnium.iast.thirdparty.org.apache.commons.logging.LogFactory;
import com.secnium.iast.thirdparty.org.apache.commons.vfs2.FileObject;
import com.secnium.iast.thirdparty.org.apache.commons.vfs2.FileSystemException;
import com.secnium.iast.thirdparty.org.apache.commons.vfs2.FileSystemManager;
import com.secnium.iast.thirdparty.org.apache.commons.vfs2.VFS;

public class VFSFileChangedReloadingStrategy
implements ReloadingStrategy {
    private static final int DEFAULT_REFRESH_DELAY = 5000;
    protected FileConfiguration configuration;
    protected long lastModified;
    protected long lastChecked;
    protected long refreshDelay = 5000L;
    private boolean reloading;
    private Log log = LogFactory.getLog(this.getClass());

    public void setConfiguration(FileConfiguration fileConfiguration) {
        this.configuration = fileConfiguration;
    }

    public void init() {
        if (this.configuration.getURL() == null && this.configuration.getFileName() == null) {
            return;
        }
        if (this.configuration == null) {
            throw new IllegalStateException("No configuration has been set for this strategy");
        }
        this.updateLastModified();
    }

    public boolean reloadingRequired() {
        long l;
        if (!this.reloading && (l = System.currentTimeMillis()) > this.lastChecked + this.refreshDelay) {
            this.lastChecked = l;
            if (this.hasChanged()) {
                this.reloading = true;
            }
        }
        return this.reloading;
    }

    public void reloadingPerformed() {
        this.updateLastModified();
    }

    public long getRefreshDelay() {
        return this.refreshDelay;
    }

    public void setRefreshDelay(long l) {
        this.refreshDelay = l;
    }

    protected void updateLastModified() {
        FileObject fileObject = this.getFile();
        if (fileObject != null) {
            try {
                this.lastModified = fileObject.getContent().getLastModifiedTime();
            }
            catch (FileSystemException fileSystemException) {
                this.log.error("Unable to get last modified time for" + fileObject.getName().getURI());
            }
        }
        this.reloading = false;
    }

    protected boolean hasChanged() {
        FileObject fileObject = this.getFile();
        try {
            if (fileObject == null || !fileObject.exists()) {
                return false;
            }
            return fileObject.getContent().getLastModifiedTime() > this.lastModified;
        }
        catch (FileSystemException fileSystemException) {
            this.log.error("Unable to get last modified time for" + fileObject.getName().getURI());
            return false;
        }
    }

    protected FileObject getFile() {
        try {
            FileSystemManager fileSystemManager = VFS.getManager();
            FileSystem fileSystem = ((FileSystemBased)((Object)this.configuration)).getFileSystem();
            String string = fileSystem.getPath(null, this.configuration.getURL(), this.configuration.getBasePath(), this.configuration.getFileName());
            if (string == null) {
                throw new ConfigurationRuntimeException("Unable to determine file to monitor");
            }
            return fileSystemManager.resolveFile(string);
        }
        catch (FileSystemException fileSystemException) {
            String string = "Unable to monitor " + this.configuration.getURL().toString();
            this.log.error(string);
            throw new ConfigurationRuntimeException(string, fileSystemException);
        }
    }
}

