/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.instrument.matcher.operator;

import com.navercorp.pinpoint.bootstrap.instrument.matcher.operand.AbstractMatcherOperand;
import com.navercorp.pinpoint.bootstrap.instrument.matcher.operand.MatcherOperand;
import com.navercorp.pinpoint.bootstrap.instrument.matcher.operator.MatcherOperator;
import com.navercorp.pinpoint.common.annotations.InterfaceStability;
import com.navercorp.pinpoint.common.util.Assert;

@InterfaceStability.Unstable
public class NotMatcherOperator
extends AbstractMatcherOperand
implements MatcherOperator {
    private final MatcherOperand rightOperand;

    public NotMatcherOperator(MatcherOperand rightOperand) {
        this.rightOperand = Assert.requireNonNull(rightOperand, "rightOperand must not be null");
    }

    @Override
    public int getPrecedence() {
        return 3;
    }

    @Override
    public boolean isOperator() {
        return true;
    }

    @Override
    public boolean isIndex() {
        return false;
    }

    @Override
    public MatcherOperand getLeftOperand() {
        return null;
    }

    @Override
    public MatcherOperand getRightOperand() {
        return this.rightOperand;
    }

    @Override
    public int getExecutionCost() {
        return this.rightOperand.getExecutionCost();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("NOT ").append(this.rightOperand);
        return sb.toString();
    }
}

