/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.instrument.scanner;

import com.navercorp.pinpoint.common.util.CodeSourceUtils;
import com.navercorp.pinpoint.profiler.instrument.scanner.ClassLoaderScanner;
import com.navercorp.pinpoint.profiler.instrument.scanner.DirectoryScanner;
import com.navercorp.pinpoint.profiler.instrument.scanner.JarFileScanner;
import com.navercorp.pinpoint.profiler.instrument.scanner.Scanner;
import java.net.URL;
import java.security.ProtectionDomain;

public class ClassScannerFactory {
    private static final String FORCE_CLASS_LOADER_SCANNER_PROPERTY_KEY = "pinpoint.force.classloader.scanner";
    private static final boolean FORCE_CLASS_LOADER_SCANNER = ClassScannerFactory.forceClassLoaderScanner();
    private static final String[] FILE_PROTOCOLS = new String[]{"file", "vfs"};
    private static final String[] JAR_EXTENSIONS = new String[]{".jar", ".war", ".ear"};

    public static Scanner newScanner(ProtectionDomain protectionDomain, ClassLoader classLoader) {
        ClassLoader protectionDomainClassLoader;
        URL codeLocation = CodeSourceUtils.getCodeLocation((ProtectionDomain)protectionDomain);
        if (codeLocation == null) {
            return new ClassLoaderScanner(classLoader);
        }
        String protocol = codeLocation.getProtocol();
        if (ClassScannerFactory.isFileProtocol(protocol)) {
            String path = codeLocation.getPath();
            boolean isJarFile = ClassScannerFactory.isJarExtension(path);
            if (isJarFile) {
                return new JarFileScanner(path);
            }
            boolean isDirectory = path.endsWith("/");
            if (isDirectory) {
                return new DirectoryScanner(path);
            }
        }
        if ((FORCE_CLASS_LOADER_SCANNER || ClassScannerFactory.isNestedJar(codeLocation.getPath())) && (protectionDomainClassLoader = protectionDomain.getClassLoader()) != null) {
            return new ClassLoaderScanner(protectionDomainClassLoader);
        }
        throw new IllegalArgumentException("unknown scanner type classLoader:" + classLoader + " protectionDomain:" + protectionDomain);
    }

    static boolean isJarExtension(String path) {
        if (path == null) {
            return false;
        }
        for (String extension : JAR_EXTENSIONS) {
            if (!path.endsWith(extension)) continue;
            return true;
        }
        return false;
    }

    static boolean isFileProtocol(String protocol) {
        for (String fileProtocol : FILE_PROTOCOLS) {
            if (!fileProtocol.equals(protocol)) continue;
            return true;
        }
        return false;
    }

    static boolean isNestedJar(String path) {
        if (path == null) {
            return false;
        }
        String separator = "!/";
        if (!path.endsWith("!/")) {
            return false;
        }
        String subPath = path.substring(0, path.lastIndexOf("!/"));
        return subPath.contains("!/");
    }

    private static boolean forceClassLoaderScanner() {
        String forceClassLoaderScanner = System.getProperty(FORCE_CLASS_LOADER_SCANNER_PROPERTY_KEY);
        return Boolean.parseBoolean(forceClassLoaderScanner);
    }
}

