/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.monitor.collector.jvmgc;

import com.navercorp.pinpoint.profiler.monitor.collector.AgentStatMetricCollector;
import com.navercorp.pinpoint.profiler.monitor.collector.jvmgc.BasicJvmGcMetricCollector;
import com.navercorp.pinpoint.profiler.monitor.metric.gc.DetailedGarbageCollectorMetric;
import com.navercorp.pinpoint.profiler.monitor.metric.gc.DetailedGarbageCollectorMetricSnapshot;
import com.navercorp.pinpoint.profiler.monitor.metric.memory.DetailedMemoryMetric;
import com.navercorp.pinpoint.profiler.monitor.metric.memory.DetailedMemoryMetricSnapshot;
import com.navercorp.pinpoint.thrift.dto.TJvmGc;
import com.navercorp.pinpoint.thrift.dto.TJvmGcDetailed;

public class DetailedJvmGcMetricCollector
implements AgentStatMetricCollector<TJvmGc> {
    private final BasicJvmGcMetricCollector jvmGcMetricCollector;
    private final DetailedMemoryMetric detailedMemoryMetric;
    private final DetailedGarbageCollectorMetric detailedGarbageCollectorMetric;

    public DetailedJvmGcMetricCollector(BasicJvmGcMetricCollector jvmGcMetricCollector, DetailedMemoryMetric detailedMemoryMetric, DetailedGarbageCollectorMetric detailedGarbageCollectorMetric) {
        if (jvmGcMetricCollector == null) {
            throw new NullPointerException("jvmGcMetricCollector must not be null");
        }
        if (detailedMemoryMetric == null) {
            throw new NullPointerException("detailedMemoryMetric must not be null");
        }
        if (detailedGarbageCollectorMetric == null) {
            throw new NullPointerException("detailedGarbageCollectorMetric must not be null");
        }
        this.jvmGcMetricCollector = jvmGcMetricCollector;
        this.detailedMemoryMetric = detailedMemoryMetric;
        this.detailedGarbageCollectorMetric = detailedGarbageCollectorMetric;
    }

    @Override
    public TJvmGc collect() {
        TJvmGc jvmGc = this.jvmGcMetricCollector.collect();
        DetailedMemoryMetricSnapshot detailedMemoryMetricSnapshot = this.detailedMemoryMetric.getSnapshot();
        DetailedGarbageCollectorMetricSnapshot detailedGarbageCollectorMetricSnapshot = this.detailedGarbageCollectorMetric.getSnapshot();
        TJvmGcDetailed jvmGcDetailed = new TJvmGcDetailed();
        jvmGcDetailed.setJvmPoolNewGenUsed(detailedMemoryMetricSnapshot.getNewGenUsage());
        jvmGcDetailed.setJvmPoolOldGenUsed(detailedMemoryMetricSnapshot.getOldGenUsage());
        jvmGcDetailed.setJvmPoolSurvivorSpaceUsed(detailedMemoryMetricSnapshot.getSurvivorSpaceUsage());
        jvmGcDetailed.setJvmPoolCodeCacheUsed(detailedMemoryMetricSnapshot.getCodeCacheUsage());
        jvmGcDetailed.setJvmPoolPermGenUsed(detailedMemoryMetricSnapshot.getPermGenUsage());
        jvmGcDetailed.setJvmPoolMetaspaceUsed(detailedMemoryMetricSnapshot.getMetaspaceUsage());
        jvmGcDetailed.setJvmGcNewCount(detailedGarbageCollectorMetricSnapshot.getGcNewCount());
        jvmGcDetailed.setJvmGcNewTime(detailedGarbageCollectorMetricSnapshot.getGcNewTime());
        jvmGc.setJvmGcDetailed(jvmGcDetailed);
        return jvmGc;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DetailedJvmGcMetricCollector{");
        sb.append("jvmGcMetricCollector=").append(this.jvmGcMetricCollector);
        sb.append(", detailedMemoryMetric=").append(this.detailedMemoryMetric);
        sb.append(", detailedGarbageCollectorMetric=").append(this.detailedGarbageCollectorMetric);
        sb.append('}');
        return sb.toString();
    }
}

