/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context;

import com.navercorp.pinpoint.bootstrap.context.SpanRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceId;
import com.navercorp.pinpoint.bootstrap.sampler.TraceSampler;
import com.navercorp.pinpoint.common.annotations.InterfaceAudience;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.profiler.context.AsyncChildTrace;
import com.navercorp.pinpoint.profiler.context.AsyncContextFactory;
import com.navercorp.pinpoint.profiler.context.AsyncTrace;
import com.navercorp.pinpoint.profiler.context.BaseTraceFactory;
import com.navercorp.pinpoint.profiler.context.CallStack;
import com.navercorp.pinpoint.profiler.context.CallStackFactory;
import com.navercorp.pinpoint.profiler.context.DefaultTrace;
import com.navercorp.pinpoint.profiler.context.DisableTrace;
import com.navercorp.pinpoint.profiler.context.LocalAsyncId;
import com.navercorp.pinpoint.profiler.context.Span;
import com.navercorp.pinpoint.profiler.context.SpanAsyncStateListener;
import com.navercorp.pinpoint.profiler.context.SpanEvent;
import com.navercorp.pinpoint.profiler.context.SpanFactory;
import com.navercorp.pinpoint.profiler.context.active.ActiveTraceHandle;
import com.navercorp.pinpoint.profiler.context.active.ActiveTraceRepository;
import com.navercorp.pinpoint.profiler.context.id.ListenableAsyncState;
import com.navercorp.pinpoint.profiler.context.id.TraceRoot;
import com.navercorp.pinpoint.profiler.context.id.TraceRootFactory;
import com.navercorp.pinpoint.profiler.context.recorder.RecorderFactory;
import com.navercorp.pinpoint.profiler.context.recorder.WrappedSpanEventRecorder;
import com.navercorp.pinpoint.profiler.context.storage.Storage;
import com.navercorp.pinpoint.profiler.context.storage.StorageFactory;

public class DefaultBaseTraceFactory
implements BaseTraceFactory {
    private final CallStackFactory<SpanEvent> callStackFactory;
    private final StorageFactory storageFactory;
    private final TraceSampler traceSampler;
    private final AsyncContextFactory asyncContextFactory;
    private final SpanFactory spanFactory;
    private final RecorderFactory recorderFactory;
    private final TraceRootFactory traceRootFactory;
    private final ActiveTraceRepository activeTraceRepository;

    public DefaultBaseTraceFactory(TraceRootFactory traceRootFactory, CallStackFactory<SpanEvent> callStackFactory, StorageFactory storageFactory, TraceSampler traceSampler, AsyncContextFactory asyncContextFactory, SpanFactory spanFactory, RecorderFactory recorderFactory, ActiveTraceRepository activeTraceRepository) {
        this.traceRootFactory = (TraceRootFactory)Assert.requireNonNull((Object)traceRootFactory, (String)"traceRootFactory");
        this.callStackFactory = (CallStackFactory)Assert.requireNonNull(callStackFactory, (String)"callStackFactory");
        this.storageFactory = (StorageFactory)Assert.requireNonNull((Object)storageFactory, (String)"storageFactory");
        this.traceSampler = (TraceSampler)Assert.requireNonNull((Object)traceSampler, (String)"traceSampler");
        this.asyncContextFactory = (AsyncContextFactory)Assert.requireNonNull((Object)asyncContextFactory, (String)"asyncContextFactory");
        this.spanFactory = (SpanFactory)Assert.requireNonNull((Object)spanFactory, (String)"spanFactory");
        this.recorderFactory = (RecorderFactory)Assert.requireNonNull((Object)recorderFactory, (String)"recorderFactory");
        this.activeTraceRepository = (ActiveTraceRepository)Assert.requireNonNull((Object)activeTraceRepository, (String)"activeTraceRepository");
    }

    @Override
    public Trace continueTraceObject(TraceId traceId) {
        TraceSampler.State state = this.traceSampler.isContinueSampled();
        if (state.isSampled()) {
            TraceRoot traceRoot = this.traceRootFactory.continueTraceRoot(traceId, state.nextId());
            Span span = this.spanFactory.newSpan(traceRoot);
            Storage storage = this.storageFactory.createStorage(traceRoot);
            CallStack<SpanEvent> callStack = this.callStackFactory.newCallStack();
            boolean samplingEnable = true;
            SpanRecorder spanRecorder = this.recorderFactory.newSpanRecorder(span, traceId.isRoot(), true);
            WrappedSpanEventRecorder wrappedSpanEventRecorder = this.recorderFactory.newWrappedSpanEventRecorder(traceRoot);
            ActiveTraceHandle handle = this.registerActiveTrace(traceRoot);
            DefaultTrace trace = new DefaultTrace(span, callStack, storage, this.asyncContextFactory, true, spanRecorder, wrappedSpanEventRecorder, handle);
            return trace;
        }
        return this.newDisableTrace(state.nextId());
    }

    private ActiveTraceHandle registerActiveTrace(TraceRoot traceRoot) {
        return this.activeTraceRepository.register(traceRoot);
    }

    private ActiveTraceHandle registerActiveTrace(long localTransactionId, long startTime, long threadId) {
        return this.activeTraceRepository.register(localTransactionId, startTime, threadId);
    }

    @Override
    public Trace newTraceObject() {
        TraceSampler.State state = this.traceSampler.isNewSampled();
        boolean sampling = state.isSampled();
        if (sampling) {
            TraceRoot traceRoot = this.traceRootFactory.newTraceRoot(state.nextId());
            Span span = this.spanFactory.newSpan(traceRoot);
            Storage storage = this.storageFactory.createStorage(traceRoot);
            CallStack<SpanEvent> callStack = this.callStackFactory.newCallStack();
            TraceId traceId = traceRoot.getTraceId();
            SpanRecorder spanRecorder = this.recorderFactory.newSpanRecorder(span, traceId.isRoot(), sampling);
            WrappedSpanEventRecorder wrappedSpanEventRecorder = this.recorderFactory.newWrappedSpanEventRecorder(traceRoot);
            ActiveTraceHandle handle = this.registerActiveTrace(traceRoot);
            DefaultTrace trace = new DefaultTrace(span, callStack, storage, this.asyncContextFactory, sampling, spanRecorder, wrappedSpanEventRecorder, handle);
            return trace;
        }
        return this.newDisableTrace(state.nextId());
    }

    @Override
    public Trace continueAsyncTraceObject(TraceRoot traceRoot, LocalAsyncId localAsyncId) {
        Storage storage = this.storageFactory.createStorage(traceRoot);
        CallStack<SpanEvent> callStack = this.callStackFactory.newCallStack();
        boolean samplingEnable = true;
        SpanRecorder spanRecorder = this.recorderFactory.newTraceRootSpanRecorder(traceRoot, true);
        WrappedSpanEventRecorder wrappedSpanEventRecorder = this.recorderFactory.newWrappedSpanEventRecorder(traceRoot);
        AsyncChildTrace asyncTrace = new AsyncChildTrace(traceRoot, callStack, storage, this.asyncContextFactory, true, spanRecorder, wrappedSpanEventRecorder, localAsyncId);
        return asyncTrace;
    }

    @Override
    @InterfaceAudience.LimitedPrivate(value={"vert.x"})
    public Trace continueAsyncTraceObject(TraceId traceId) {
        TraceSampler.State state = this.traceSampler.isContinueSampled();
        boolean sampling = state.isSampled();
        if (sampling) {
            TraceRoot traceRoot = this.traceRootFactory.continueTraceRoot(traceId, state.nextId());
            Span span = this.spanFactory.newSpan(traceRoot);
            Storage storage = this.storageFactory.createStorage(traceRoot);
            CallStack<SpanEvent> callStack = this.callStackFactory.newCallStack();
            ActiveTraceHandle handle = this.registerActiveTrace(traceRoot);
            SpanAsyncStateListener asyncStateListener = new SpanAsyncStateListener(span, this.storageFactory);
            ListenableAsyncState asyncState = new ListenableAsyncState(asyncStateListener, handle);
            SpanRecorder spanRecorder = this.recorderFactory.newSpanRecorder(span, traceId.isRoot(), sampling);
            WrappedSpanEventRecorder wrappedSpanEventRecorder = this.recorderFactory.newWrappedSpanEventRecorder(traceRoot, asyncState);
            DefaultTrace trace = new DefaultTrace(span, callStack, storage, this.asyncContextFactory, sampling, spanRecorder, wrappedSpanEventRecorder, ActiveTraceHandle.EMPTY_HANDLE);
            AsyncTrace asyncTrace = new AsyncTrace(this.asyncContextFactory, traceRoot, trace, asyncState);
            return asyncTrace;
        }
        return this.newDisableTrace(state.nextId());
    }

    @Override
    @InterfaceAudience.LimitedPrivate(value={"vert.x"})
    public Trace newAsyncTraceObject() {
        TraceSampler.State state = this.traceSampler.isNewSampled();
        boolean sampling = state.isSampled();
        if (sampling) {
            TraceRoot traceRoot = this.traceRootFactory.newTraceRoot(state.nextId());
            Span span = this.spanFactory.newSpan(traceRoot);
            Storage storage = this.storageFactory.createStorage(traceRoot);
            CallStack<SpanEvent> callStack = this.callStackFactory.newCallStack();
            ActiveTraceHandle handle = this.registerActiveTrace(traceRoot);
            SpanAsyncStateListener asyncStateListener = new SpanAsyncStateListener(span, this.storageFactory);
            ListenableAsyncState asyncState = new ListenableAsyncState(asyncStateListener, handle);
            TraceId traceId = traceRoot.getTraceId();
            SpanRecorder spanRecorder = this.recorderFactory.newSpanRecorder(span, traceId.isRoot(), sampling);
            WrappedSpanEventRecorder wrappedSpanEventRecorder = this.recorderFactory.newWrappedSpanEventRecorder(traceRoot, asyncState);
            DefaultTrace trace = new DefaultTrace(span, callStack, storage, this.asyncContextFactory, sampling, spanRecorder, wrappedSpanEventRecorder, ActiveTraceHandle.EMPTY_HANDLE);
            AsyncTrace asyncTrace = new AsyncTrace(this.asyncContextFactory, traceRoot, trace, asyncState);
            return asyncTrace;
        }
        return this.newDisableTrace(state.nextId());
    }

    @Override
    public Trace disableSampling() {
        TraceSampler.State state = this.traceSampler.getContinueDisableState();
        long nextContinuedDisabledId = state.nextId();
        return this.newDisableTrace(nextContinuedDisabledId);
    }

    private Trace newDisableTrace(long nextDisabledId) {
        long traceStartTime = System.currentTimeMillis();
        long threadId = Thread.currentThread().getId();
        ActiveTraceHandle activeTraceHandle = this.registerActiveTrace(nextDisabledId, traceStartTime, threadId);
        DisableTrace disableTrace = new DisableTrace(nextDisabledId, traceStartTime, threadId, activeTraceHandle);
        return disableTrace;
    }
}

