/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.config;

import com.navercorp.pinpoint.bootstrap.config.Filter;
import com.navercorp.pinpoint.common.util.StringUtils;
import java.util.HashSet;
import java.util.Set;

public class ProfilableClassFilter
implements Filter<String> {
    private final Set<String> profileInclude = new HashSet<String>();
    private final Set<String> profileIncludeSub = new HashSet<String>();

    public ProfilableClassFilter(String profilableClass) {
        String[] className;
        if (StringUtils.isEmpty(profilableClass)) {
            return;
        }
        for (String str : className = profilableClass.split(",")) {
            if (str.endsWith(".*")) {
                this.profileIncludeSub.add(str.substring(0, str.length() - 2).replace('.', '/') + "/");
                continue;
            }
            String replace = str.trim().replace('.', '/');
            this.profileInclude.add(replace);
        }
    }

    @Override
    public boolean filter(String className) {
        if (this.profileInclude.contains(className)) {
            return true;
        }
        String packageName = className.substring(0, className.lastIndexOf("/") + 1);
        for (String pkg : this.profileIncludeSub) {
            if (!packageName.startsWith(pkg)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ProfilableClassFilter{");
        sb.append("profileInclude=").append(this.profileInclude);
        sb.append(", profileIncludeSub=").append(this.profileIncludeSub);
        sb.append('}');
        return sb.toString();
    }
}

