/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.httpclient3;

import com.navercorp.pinpoint.bootstrap.config.DumpType;
import com.navercorp.pinpoint.bootstrap.config.HttpDumpConfig;
import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;

public class HttpClient3PluginConfig {
    private boolean param = true;
    private boolean io;
    private HttpDumpConfig httpDumpConfig;

    public HttpClient3PluginConfig(ProfilerConfig src) {
        this.param = src.readBoolean("profiler.apache.httpclient3.param", true);
        boolean cookie = src.readBoolean("profiler.apache.httpclient3.cookie", false);
        DumpType cookieDumpType = src.readDumpType("profiler.apache.httpclient3.cookie.dumptype", DumpType.EXCEPTION);
        int cookieSamplingRate = src.readInt("profiler.apache.httpclient3.cookie.sampling.rate", 1);
        int cookieDumpSize = src.readInt("profiler.apache.httpclient3.cookie.dumpsize", 1024);
        boolean entity = src.readBoolean("profiler.apache.httpclient3.entity", false);
        DumpType entityDumpType = src.readDumpType("profiler.apache.httpclient3.entity.dumptype", DumpType.EXCEPTION);
        int entitySamplingRate = src.readInt("profiler.apache.httpclient3.entity.sampling.rate", 1);
        int entityDumpSize = src.readInt("profiler.apache.httpclient3.entity.dumpsize", 1024);
        this.httpDumpConfig = HttpDumpConfig.get((boolean)cookie, (DumpType)cookieDumpType, (int)cookieSamplingRate, (int)cookieDumpSize, (boolean)entity, (DumpType)entityDumpType, (int)entitySamplingRate, (int)entityDumpSize);
        this.io = src.readBoolean("profiler.apache.httpclient3.io", true);
    }

    public boolean isParam() {
        return this.param;
    }

    public HttpDumpConfig getHttpDumpConfig() {
        return this.httpDumpConfig;
    }

    public boolean isIo() {
        return this.io;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("HttpClient3PluginConfig{");
        sb.append("param=").append(this.param);
        sb.append(", io=").append(this.io);
        sb.append(", httpDumpConfig=").append(this.httpDumpConfig);
        sb.append('}');
        return sb.toString();
    }
}

