/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.arcus;

import com.navercorp.pinpoint.bootstrap.async.AsyncContextAccessor;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentClass;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentException;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentMethod;
import com.navercorp.pinpoint.bootstrap.instrument.Instrumentor;
import com.navercorp.pinpoint.bootstrap.instrument.MethodFilter;
import com.navercorp.pinpoint.bootstrap.instrument.MethodFilters;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformCallback;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplate;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplateAware;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPlugin;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPluginSetupContext;
import com.navercorp.pinpoint.bootstrap.plugin.util.InstrumentUtils;
import com.navercorp.pinpoint.common.util.VarArgs;
import com.navercorp.pinpoint.plugin.arcus.ArcusPluginConfig;
import com.navercorp.pinpoint.plugin.arcus.filter.ArcusMethodFilter;
import com.navercorp.pinpoint.plugin.arcus.filter.FrontCacheMemcachedMethodFilter;
import java.security.ProtectionDomain;

public class ArcusPlugin
implements ProfilerPlugin,
TransformTemplateAware {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private TransformTemplate transformTemplate;
    private static final TransformCallback FUTURE_TRANSFORMER = new TransformCallback(){

        public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
            InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
            target.addField("com.navercorp.pinpoint.plugin.arcus.OperationAccessor");
            target.addField(AsyncContextAccessor.class.getName());
            InstrumentMethod setOperation = target.getDeclaredMethod("setOperation", new String[]{"net.spy.memcached.ops.Operation"});
            if (setOperation != null) {
                setOperation.addInterceptor("com.navercorp.pinpoint.plugin.arcus.interceptor.FutureSetOperationInterceptor");
            }
            for (InstrumentMethod m : target.getDeclaredMethods(MethodFilters.name((String[])new String[]{"cancel", "get", "set", "signalComplete"}))) {
                m.addScopedInterceptor("com.navercorp.pinpoint.plugin.arcus.interceptor.FutureGetInterceptor", "ArcusFutureScope");
            }
            return target.toBytecode();
        }
    };
    private static final TransformCallback FUTURE_SET_OPERATION_TRANSFORMER = new TransformCallback(){

        public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
            InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
            target.addField("com.navercorp.pinpoint.plugin.arcus.OperationAccessor");
            InstrumentMethod setOperation = target.getDeclaredMethod("setOperation", new String[]{"net.spy.memcached.ops.Operation"});
            if (setOperation != null) {
                setOperation.addInterceptor("com.navercorp.pinpoint.plugin.arcus.interceptor.FutureSetOperationInterceptor");
            }
            return target.toBytecode();
        }
    };
    private static final TransformCallback INTERNAL_FUTURE_TRANSFORMER = new TransformCallback(){

        public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
            InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
            target.addField(AsyncContextAccessor.class.getName());
            for (InstrumentMethod m : target.getDeclaredMethods(MethodFilters.name((String[])new String[]{"cancel", "get"}))) {
                m.addScopedInterceptor("com.navercorp.pinpoint.plugin.arcus.interceptor.FutureInternalMethodInterceptor", "ArcusFutureScope");
            }
            return target.toBytecode();
        }
    };

    public void setup(ProfilerPluginSetupContext context) {
        ArcusPluginConfig config = new ArcusPluginConfig(context.getConfig());
        boolean arcus = config.isArcus();
        boolean arcusAsync = config.isArcusAsync();
        boolean memcached = config.isMemcached();
        boolean memcachedAsync = config.isMemcachedAsync();
        if (arcus) {
            this.addArcusClientEditor(config);
            this.addCollectionFutureEditor(arcusAsync);
            this.addFrontCacheGetFutureEditor();
            this.addFrontCacheMemcachedClientEditor(config);
            this.addCacheManagerEditor();
            this.addBTreeStoreGetFutureEditor(arcusAsync);
            this.addCollectionGetBulkFutureEditor(arcusAsync);
            this.addSMGetFutureFutureEditor(arcusAsync);
        }
        if (arcus || memcached) {
            this.addMemcachedClientEditor(config);
            this.addBaseOperationImplEditor();
            boolean async = arcusAsync || memcachedAsync;
            this.addGetFutureEditor(async);
            this.addOperationFutureEditor(async);
            this.addImmediateFutureEditor(async);
            this.addBulkGetFutureEditor(async);
        }
    }

    private void addArcusClientEditor(final ArcusPluginConfig config) {
        this.transformTemplate.transform("net.spy.memcached.ArcusClient", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                if (target.hasMethod("addOp", new String[]{"java.lang.String", "net.spy.memcached.ops.Operation"})) {
                    boolean traceKey = config.isArcusKeyTrace();
                    InstrumentMethod setCacheManagerMethod = InstrumentUtils.findMethod((InstrumentClass)target, (String)"setCacheManager", (String[])new String[]{"net.spy.memcached.CacheManager"});
                    setCacheManagerMethod.addInterceptor("com.navercorp.pinpoint.plugin.arcus.interceptor.SetCacheManagerInterceptor");
                    for (InstrumentMethod m : target.getDeclaredMethods((MethodFilter)new ArcusMethodFilter())) {
                        try {
                            m.addScopedInterceptor("com.navercorp.pinpoint.plugin.arcus.interceptor.ApiInterceptor", VarArgs.va((Object[])new Object[]{traceKey}), "ArcusScope");
                        }
                        catch (Exception e) {
                            if (!ArcusPlugin.this.logger.isWarnEnabled()) continue;
                            ArcusPlugin.this.logger.warn("Unsupported method " + className + "." + m.getName(), (Throwable)e);
                        }
                    }
                    return target.toBytecode();
                }
                return null;
            }
        });
    }

    private void addCacheManagerEditor() {
        this.transformTemplate.transform("net.spy.memcached.CacheManager", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                target.addField("com.navercorp.pinpoint.plugin.arcus.ServiceCodeAccessor");
                InstrumentMethod constructorMethod = InstrumentUtils.findConstructor((InstrumentClass)target, (String[])new String[]{"java.lang.String", "java.lang.String", "net.spy.memcached.ConnectionFactoryBuilder", "java.util.concurrent.CountDownLatch", "int", "int"});
                constructorMethod.addInterceptor("com.navercorp.pinpoint.plugin.arcus.interceptor.CacheManagerConstructInterceptor");
                return target.toBytecode();
            }
        });
    }

    private void addBaseOperationImplEditor() {
        this.transformTemplate.transform("net.spy.memcached.protocol.BaseOperationImpl", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                target.addField("com.navercorp.pinpoint.plugin.arcus.ServiceCodeAccessor");
                return target.toBytecode();
            }
        });
    }

    private void addFrontCacheGetFutureEditor() {
        this.transformTemplate.transform("net.spy.memcached.plugin.FrontCacheGetFuture", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                target.addField("com.navercorp.pinpoint.plugin.arcus.CacheNameAccessor");
                target.addField("com.navercorp.pinpoint.plugin.arcus.CacheKeyAccessor");
                InstrumentMethod constructorMethod = InstrumentUtils.findConstructor((InstrumentClass)target, (String[])new String[]{"net.sf.ehcache.Element"});
                constructorMethod.addInterceptor("com.navercorp.pinpoint.plugin.arcus.interceptor.FrontCacheGetFutureConstructInterceptor");
                InstrumentMethod get0 = InstrumentUtils.findMethod((InstrumentClass)target, (String)"get", (String[])new String[]{"long", "java.util.concurrent.TimeUnit"});
                get0.addScopedInterceptor("com.navercorp.pinpoint.plugin.arcus.interceptor.FrontCacheGetFutureGetInterceptor", "ArcusScope");
                InstrumentMethod get1 = InstrumentUtils.findMethod((InstrumentClass)target, (String)"get", (String[])new String[0]);
                get1.addScopedInterceptor("com.navercorp.pinpoint.plugin.arcus.interceptor.FrontCacheGetFutureGetInterceptor", "ArcusScope");
                return target.toBytecode();
            }
        });
    }

    private void addFrontCacheMemcachedClientEditor(final ArcusPluginConfig config) {
        this.transformTemplate.transform("net.spy.memcached.plugin.FrontCacheMemcachedClient", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                boolean traceKey = config.isMemcachedKeyTrace();
                for (InstrumentMethod m : target.getDeclaredMethods((MethodFilter)new FrontCacheMemcachedMethodFilter())) {
                    try {
                        m.addScopedInterceptor("com.navercorp.pinpoint.plugin.arcus.interceptor.ApiInterceptor", VarArgs.va((Object[])new Object[]{traceKey}), "ArcusScope");
                    }
                    catch (Exception e) {
                        if (!ArcusPlugin.this.logger.isWarnEnabled()) continue;
                        ArcusPlugin.this.logger.warn("Unsupported method " + className + "." + m.getName(), (Throwable)e);
                    }
                }
                return target.toBytecode();
            }
        });
    }

    private void addMemcachedClientEditor(final ArcusPluginConfig config) {
        this.transformTemplate.transform("net.spy.memcached.MemcachedClient", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                if (target.hasDeclaredMethod("addOp", new String[]{"java.lang.String", "net.spy.memcached.ops.Operation"})) {
                    target.addField("com.navercorp.pinpoint.plugin.arcus.ServiceCodeAccessor");
                    InstrumentMethod addOpMethod = InstrumentUtils.findMethod((InstrumentClass)target, (String)"addOp", (String[])new String[]{"java.lang.String", "net.spy.memcached.ops.Operation"});
                    addOpMethod.addInterceptor("com.navercorp.pinpoint.plugin.arcus.interceptor.AddOpInterceptor");
                }
                boolean traceKey = config.isMemcachedKeyTrace();
                for (InstrumentMethod m : target.getDeclaredMethods((MethodFilter)new FrontCacheMemcachedMethodFilter())) {
                    try {
                        m.addScopedInterceptor("com.navercorp.pinpoint.plugin.arcus.interceptor.ApiInterceptor", VarArgs.va((Object[])new Object[]{traceKey}), "ArcusScope");
                    }
                    catch (Exception e) {
                        if (!ArcusPlugin.this.logger.isWarnEnabled()) continue;
                        ArcusPlugin.this.logger.warn("Unsupported method " + className + "." + m.getName(), (Throwable)e);
                    }
                }
                return target.toBytecode();
            }
        });
    }

    private void addCollectionFutureEditor(boolean async) {
        if (async) {
            this.transformTemplate.transform("net.spy.memcached.internal.CollectionFuture", FUTURE_TRANSFORMER);
        } else {
            this.transformTemplate.transform("net.spy.memcached.internal.CollectionFuture", FUTURE_SET_OPERATION_TRANSFORMER);
        }
    }

    private void addGetFutureEditor(boolean async) {
        if (async) {
            this.transformTemplate.transform("net.spy.memcached.internal.GetFuture", FUTURE_TRANSFORMER);
        } else {
            this.transformTemplate.transform("net.spy.memcached.internal.GetFuture", FUTURE_SET_OPERATION_TRANSFORMER);
        }
    }

    private void addOperationFutureEditor(boolean async) {
        if (async) {
            this.transformTemplate.transform("net.spy.memcached.internal.OperationFuture", FUTURE_TRANSFORMER);
        } else {
            this.transformTemplate.transform("net.spy.memcached.internal.OperationFuture", FUTURE_SET_OPERATION_TRANSFORMER);
        }
    }

    private void addImmediateFutureEditor(boolean async) {
        if (async) {
            this.transformTemplate.transform("net.spy.memcached.internal.ImmediateFuture", INTERNAL_FUTURE_TRANSFORMER);
        }
    }

    private void addBulkGetFutureEditor(boolean async) {
        if (async) {
            this.transformTemplate.transform("net.spy.memcached.internal.BulkGetFuture", INTERNAL_FUTURE_TRANSFORMER);
        }
    }

    private void addBTreeStoreGetFutureEditor(boolean async) {
        if (async) {
            this.transformTemplate.transform("net.spy.memcached.internal.BTreeStoreAndGetFuture", INTERNAL_FUTURE_TRANSFORMER);
        }
    }

    private void addCollectionGetBulkFutureEditor(boolean async) {
        if (async) {
            this.transformTemplate.transform("net.spy.memcached.internal.CollectionGetBulkFuture", INTERNAL_FUTURE_TRANSFORMER);
        }
    }

    private void addSMGetFutureFutureEditor(boolean async) {
        if (async) {
            this.transformTemplate.transform("net.spy.memcached.internal.SMGetFuture", INTERNAL_FUTURE_TRANSFORMER);
        }
    }

    public void setTransformTemplate(TransformTemplate transformTemplate) {
        this.transformTemplate = transformTemplate;
    }
}

