/*
 * Decompiled with CFR 0.152.
 */
package com.tapm.starter;

import com.tapm.agent.libs.com.google.gson.Gson;
import com.tapm.starter.AgentJarHelper;
import com.tapm.starter.OneAgentInfo;
import com.tapm.starter.StarterProperties;
import com.tapm.starter.flow.FlowEngine;
import com.tapm.starter.flow.FlowItem;
import com.tapm.starter.flow.ProcessContext;
import com.tapm.starter.flow.exception.ProcessorExistedException;
import com.tapm.starter.flow.processors.BackupProcessor;
import com.tapm.starter.flow.processors.ClearFileProcessor;
import com.tapm.starter.flow.processors.ClearUpdateProcessor;
import com.tapm.starter.flow.processors.FinishedProcessor;
import com.tapm.starter.flow.processors.InstallAgentProcessor;
import com.tapm.starter.flow.processors.LockUpdateCheckProcessor;
import com.tapm.starter.flow.processors.MD5CheckProcessor;
import com.tapm.starter.flow.processors.OneAgentCheckProcessor;
import com.tapm.starter.flow.processors.PidLockCheckProcessor;
import com.tapm.starter.flow.processors.StartAgentProcessor;
import com.tapm.starter.flow.processors.UnLockUpdateCheckProcessor;
import com.tapm.starter.flow.processors.UninstallCheckProcessor;
import com.tapm.starter.flow.processors.UpdateCheckProcessor;
import com.tapm.starter.flow.processors.UpdateProcessor;
import com.tapm.starter.logger.ILogger;
import com.tapm.starter.logger.LoggerFactory;
import com.tapm.starter.util.AgentHelperResult;
import com.tapm.starter.util.DockerData;
import com.tapm.starter.util.HelperResult;
import com.tapm.starter.util.StarterUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.Instrumentation;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;

public class AgentStarter {
    private static ILogger logger = LoggerFactory.getLogger("AgentStarter");
    private static final UnLockUpdateCheckProcessor unLockUpdateCheckProcessor = new UnLockUpdateCheckProcessor();
    public static boolean isOneAgent = false;
    public static boolean isAutoClear;
    public static String finalLogDir;

    public static void premain(String args, Instrumentation inst) {
        AgentStarter.main(args, inst);
    }

    public static void agentmain(String args, Instrumentation inst) {
        AgentStarter.main(args, inst);
    }

    private static void prepareFlowEngine(FlowEngine flowEngine) throws ProcessorExistedException {
        flowEngine.registProcessor("lock-for-update", new LockUpdateCheckProcessor());
        flowEngine.registProcessor("unlock-for-update", unLockUpdateCheckProcessor);
        flowEngine.registProcessor("pid-lock-check", new PidLockCheckProcessor());
        flowEngine.registProcessor("finished", new FinishedProcessor());
        flowEngine.registProcessor("update-check", new UpdateCheckProcessor());
        flowEngine.registProcessor("md5-check", new MD5CheckProcessor());
        flowEngine.registProcessor("backup", new BackupProcessor());
        flowEngine.registProcessor("clear-update", new ClearUpdateProcessor());
        flowEngine.registProcessor("update", new UpdateProcessor());
        flowEngine.registProcessor("start-agent", new StartAgentProcessor());
        flowEngine.registProcessor("uninstall-check", new UninstallCheckProcessor());
        flowEngine.registProcessor("clear-file", new ClearFileProcessor());
        flowEngine.registProcessor("oneagent-check", new OneAgentCheckProcessor());
    }

    public static void main(String[] args) {
        if (!AgentStarter.checkJdk()) {
            return;
        }
        try {
            ProcessContext context = AgentStarter.generateContext();
            context.put("agent_main_args", args);
            FlowEngine flowEngine = new FlowEngine();
            flowEngine.registProcessor("install-agent", new InstallAgentProcessor());
            FlowItem installAgentFlow = FlowItem.newBuilderForProcessorName("install-agent").build();
            flowEngine.start(installAgentFlow, context);
        }
        catch (Exception e) {
            logger.error("Error install Tapm agent", e);
        }
    }

    private static boolean checkJdk() {
        String javaVersion = System.getProperty("java.version", "");
        if (javaVersion.startsWith("1.5")) {
            String msg = MessageFormat.format("Java version is: {0}.  Tapm Agent V2.x need JDK 1.6+.", javaVersion);
            System.err.println("-------------------------------");
            System.err.println(msg);
            System.err.println("-------------------------------");
            System.err.println("Tapm Agent not started.");
            return false;
        }
        return true;
    }

    private static boolean checkWritable(File agentDir) throws IOException {
        File testFile = new File(agentDir, System.currentTimeMillis() + ".test");
        if (!testFile.exists() && !testFile.createNewFile()) {
            System.err.println("Cannot create test files, this directory(" + agentDir + ") is read-only");
            return false;
        }
        if (!testFile.delete()) {
            System.err.println("Cannot delete test files, this directory({" + agentDir + ") is read-only");
            return false;
        }
        return true;
    }

    private static ProcessContext generateContext() throws IOException {
        File agentDir = AgentJarHelper.getAgentJarDirectory();
        ProcessContext context = new ProcessContext();
        context.put("Agent-Version", AgentJarHelper.getAgentVersion());
        context.put("Agent-Directory", agentDir);
        File updateDir = new File(agentDir, "update");
        context.put("Agent-Update-Directory", updateDir);
        context.put("Agent-Update-Lock-Directory", new File(updateDir, "lock"));
        context.put("Agent-Application-Pid", StarterUtil.getPid());
        String dockerContainerId = DockerData.getDockerContainerId();
        if (dockerContainerId != null) {
            context.put("Docker-Container-Id", dockerContainerId);
        }
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties fetchTapmProperties(File agentPath) throws Exception {
        Properties properties = new Properties();
        String configFilePath = AgentStarter.getTapmPropertyPath(agentPath);
        if (configFilePath == null) {
            throw new Exception("Can not found the tapm.properties file");
        }
        File file = new File(configFilePath);
        if (file.exists()) {
            FileInputStream fins = new FileInputStream(file);
            try {
                properties.load(fins);
            }
            finally {
                try {
                    fins.close();
                }
                catch (Exception exception) {}
            }
        }
        throw new Exception("File not found tapm.properties");
        return properties;
    }

    public static void main(String args, Instrumentation inst) {
        File agentPath;
        if (!AgentStarter.checkJdk()) {
            return;
        }
        try {
            agentPath = AgentJarHelper.getAgentJarDirectory();
        }
        catch (Exception e) {
            System.err.println("Failed to get Tapm agent directory " + e.getMessage());
            System.err.println("Tapm Agent not started.");
            return;
        }
        if (agentPath == null) {
            System.err.println("Failed to get Tapm agent directory.");
            return;
        }
        ProcessContext context = null;
        try {
            context = AgentStarter.generateContext();
            OneAgentInfo oneAgentInfo = OneAgentInfo.getOneAgentInfo(agentPath);
            Properties tapmProperties = AgentStarter.fetchTapmProperties(agentPath);
            Map<String, Object> oneAgentConfig = oneAgentInfo.getOneAgentConfig();
            StarterProperties starterProperties = new StarterProperties(oneAgentConfig, tapmProperties);
            context.put("properties", starterProperties);
            if (Boolean.parseBoolean(starterProperties.getProperty("agent_auto_clear.enabled", "false")) || Boolean.parseBoolean(starterProperties.getProperty("agent_log_auto_dir.enabled", "false"))) {
                isAutoClear = true;
            }
            File dataDir = AgentStarter.processDataPath(oneAgentInfo.getOneAgentPath(), agentPath, starterProperties);
            context.put("agentDataDir", dataDir.getAbsolutePath());
            String logHome = AgentStarter.processLogHome(oneAgentInfo.getOneAgentPath(), agentPath, starterProperties);
            if (logHome != null && logHome.length() > 0) {
                context.put("agentLogDir", logHome);
            }
            try {
                if (oneAgentInfo.isOneAgentMode()) {
                    isOneAgent = true;
                    context.put("oneAgentConfigFile", oneAgentInfo.getOneAgentConfigFile().getAbsolutePath());
                    context.put("oneAgentConfigMap", oneAgentInfo.getOneAgentConfig());
                    context.put("isOneAgent", true);
                    context.put("oneAgentUUID", oneAgentInfo.getOneAgentUUID());
                    logger.info("OneAgent path is {}", oneAgentInfo.getOneAgentPath());
                    String libPath = new File(oneAgentInfo.getOneAgentPath(), "lib").getAbsolutePath();
                    HelperResult helperResult = AgentStarter.getProcessNameFromAgentHelper(libPath);
                    if (helperResult == null) {
                        return;
                    }
                    if (helperResult.getHostPid() != helperResult.getPid()) {
                        context.put("hostPid", helperResult.getHostPid());
                    }
                    String processName = helperResult.getName();
                    String podName = helperResult.getPodName();
                    context.put("processName", processName);
                    context.put("podName", podName);
                }
            }
            catch (Exception e) {
                logger.error("Failed to get application name, " + e.getMessage());
                throw e;
            }
            logger.info("System.env: \n" + System.getenv());
            logger.info("System.properties: \n" + System.getProperties());
            logger.info("Processor-ID: {}", context.get("Agent-Application-Pid"));
            logger.info("Agent-Directory: {}", context.get("Agent-Directory"));
            logger.info("Agent-Directory: {}", context.get("Agent-Directory"));
            logger.info("Agent-Update-Directory: {}", context.get("Agent-Update-Directory"));
            logger.info("Agent-Version: {}", context.get("Agent-Version"));
            context.put("agent_start_args", args);
            context.put("agent_instrumentation", inst);
            FlowEngine flowEngine = new FlowEngine();
            AgentStarter.prepareFlowEngine(flowEngine);
            FlowItem startAgentFlow = FlowItem.newBuilderForProcessorName("start-agent").build();
            FlowItem clearFileFlow = FlowItem.newBuilderForProcessorName("clear-file").on("next").toProcessor(startAgentFlow).build();
            FlowItem finishedUnlockFlow = FlowItem.newBuilderForProcessorName("unlock-for-update").on("next").toProcessor("finished").build();
            FlowItem unLockUpdateFlow = FlowItem.newBuilderForProcessorName("unlock-for-update").on("next").toProcessor(clearFileFlow).build();
            FlowItem clearUpdateFlow = FlowItem.newBuilderForProcessorName("clear-update").on("next").toProcessor(unLockUpdateFlow).build();
            FlowItem updateFlow = FlowItem.newBuilderForProcessorName("update").on("next").toProcessor(unLockUpdateFlow).on("failed-next").toProcessor(unLockUpdateFlow).on("failed").toProcessor(finishedUnlockFlow).build();
            FlowItem backupFlow = FlowItem.newBuilderForProcessorName("backup").on("next").toProcessor(updateFlow).on("failed").toProcessor(clearUpdateFlow).build();
            FlowItem md5CheckFlow = FlowItem.newBuilderForProcessorName("md5-check").on("next").toProcessor(backupFlow).on("failed").toProcessor(clearUpdateFlow).build();
            FlowItem updateCheckFlow = FlowItem.newBuilderForProcessorName("update-check").on("no-update").toProcessor(unLockUpdateFlow).on("no-update-clear").toProcessor(clearUpdateFlow).on("next").toProcessor(md5CheckFlow).build();
            FlowItem pidLockCheckFlow = FlowItem.newBuilderForProcessorName("pid-lock-check").on("next").toProcessor(updateCheckFlow).build();
            FlowItem lockUpdateCheckFlow = FlowItem.newBuilderForProcessorName("lock-for-update").on("no-update").toProcessor(clearFileFlow).on("failed").toProcessor(clearFileFlow).on("next").toProcessor(pidLockCheckFlow).build();
            FlowItem oneAgentCheckFlow = FlowItem.newBuilderForProcessorName("oneagent-check").on("next").toProcessor(lockUpdateCheckFlow).on("context_is_oneagent").toProcessor(clearFileFlow).build();
            FlowItem flowItem = FlowItem.newBuilderForProcessorName("uninstall-check").on("next").toProcessor(oneAgentCheckFlow).on("uninstalled").toProcessor("finished").build();
            flowEngine.start(flowItem, context);
        }
        catch (Exception e) {
            logger.error("Error start up Tapm agent", e);
        }
        if (context != null) {
            try {
                unLockUpdateCheckProcessor.process(context);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static File getAutoDirPath(File path, StarterProperties properties) {
        String userName;
        if (Boolean.parseBoolean(properties.getProperty("agent_log_auto_dir.enabled", "false")) && (userName = System.getProperty("user.name")) != null) {
            path = new File(path, userName);
        }
        return path;
    }

    private static File processDataPath(File oneAgentPath, File agentPath, StarterProperties properties) throws IOException {
        String dataPathStr;
        File dataPath = oneAgentPath != null ? new File(oneAgentPath, "data") : ((dataPathStr = properties.getProperty("agent_data_dir")) != null ? new File(dataPathStr) : new File(agentPath, "data"));
        if (!dataPath.exists()) {
            dataPath.mkdirs();
        }
        dataPath.setExecutable(true, false);
        dataPath.setReadable(true, false);
        dataPath.setWritable(true, false);
        AgentStarter.checkWritable(dataPath);
        return dataPath;
    }

    private static String processLogHome(File oneAgentPath, File agentPath, StarterProperties properties) throws IOException {
        File logPath;
        if (oneAgentPath != null) {
            File oneAgentAgentPath = new File(oneAgentPath, "logs");
            logPath = new File(oneAgentAgentPath, "agent");
        } else {
            String defaultLogDir = new File(agentPath, "logs").getAbsolutePath();
            String logFileHome = AgentStarter.getLogDirFromProperties(properties, defaultLogDir);
            logPath = new File(logFileHome);
        }
        if (!logPath.exists()) {
            logPath.mkdirs();
        }
        logPath.setExecutable(true, false);
        logPath.setReadable(true, false);
        logPath.setWritable(true, false);
        AgentStarter.checkWritable(logPath);
        finalLogDir = logPath.getAbsolutePath();
        return finalLogDir;
    }

    private static HelperResult getProcessNameFromAgentHelper(String libPath) throws Exception {
        String pid = StarterUtil.getPid();
        String[] cmd = new String[]{libPath + "/agenthelper", "--get-hostpid", "--get-status", "--naming", pid};
        Process process = null;
        InputStream inputStream = null;
        try {
            process = Runtime.getRuntime().exec(cmd);
            inputStream = process.getInputStream();
            Scanner scanner = new Scanner(inputStream);
            StringBuilder result = new StringBuilder();
            while (scanner.hasNextLine()) {
                result.append(scanner.nextLine());
            }
            Gson gson = new Gson();
            AgentHelperResult agentHelperResult = gson.fromJson(result.toString(), AgentHelperResult.class);
            logger.info("AgentHelperResult entity : " + agentHelperResult.toString());
            if ("success".equals(agentHelperResult.getStatus()) && agentHelperResult.getResult() != null && agentHelperResult.getResult().length() > 0) {
                HelperResult[] results;
                String resultList = agentHelperResult.getResult();
                for (HelperResult helperResult : results = gson.fromJson(resultList, HelperResult[].class)) {
                    if (!pid.equals(String.valueOf(helperResult.getPid()))) continue;
                    if ("normal".equals(helperResult.getStatus())) {
                        HelperResult helperResult2 = helperResult;
                        return helperResult2;
                    }
                    logger.info("Tapm Agent Agent helper status is not normal,cause that can not started , AgentHelper response is  " + result.toString());
                    HelperResult helperResult3 = null;
                    return helperResult3;
                }
                logger.info("Tapm Agent Agent helper result not contains processId : " + pid + " ,cause that can not started , AgentHelper response is  " + result.toString());
                HelperResult helperResult = null;
                return helperResult;
            }
            logger.info("Tapm Agent Agent helper result not success ,cause that can not started , AgentHelper response is  " + result.toString());
            HelperResult helperResult = null;
            return helperResult;
        }
        catch (Exception e) {
            throw new Exception("Tapm Agent found error when executed agentHelper. caused by exception : " + e.getMessage());
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    logger.info("Tapm Agent found IOException after executed agentHelper closing inputStream. caused by exception : " + e.getMessage());
                }
            }
            if (process != null) {
                process.destroy();
            }
        }
    }

    private static String getLogDirFromProperties(StarterProperties properties, String defaultPath) {
        int lastIndexOf;
        String agentLogFileName = properties.getProperty("agent_log_file_name");
        if (agentLogFileName != null && agentLogFileName.length() > 0 && (lastIndexOf = agentLogFileName.lastIndexOf(File.separator)) > 0) {
            return agentLogFileName.substring(0, lastIndexOf);
        }
        return defaultPath;
    }

    private static String getTapmPropertyPath(File agentPath) {
        String configFilePath = System.getProperty("tapm.config.file");
        if (configFilePath != null && configFilePath.length() > 0) {
            return configFilePath;
        }
        return new File(agentPath, "tapm.properties").getAbsolutePath();
    }

    static {
        finalLogDir = null;
    }
}

