/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.jboss;

import com.navercorp.pinpoint.bootstrap.instrument.InstrumentClass;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentException;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentMethod;
import com.navercorp.pinpoint.bootstrap.instrument.Instrumentor;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformCallback;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplate;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplateAware;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.ApplicationTypeDetector;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPlugin;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPluginSetupContext;
import com.navercorp.pinpoint.bootstrap.resolver.ConditionProvider;
import com.navercorp.pinpoint.plugin.jboss.JbossConfig;
import com.navercorp.pinpoint.plugin.jboss.JbossDetector;
import java.security.ProtectionDomain;

public class JbossPlugin
implements ProfilerPlugin,
TransformTemplateAware {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isInfo = this.logger.isInfoEnabled();
    private TransformTemplate transformTemplate;

    public void setup(ProfilerPluginSetupContext context) {
        JbossConfig jbossConfig = new JbossConfig(context.getConfig());
        if (!jbossConfig.isEnable()) {
            if (this.isInfo) {
                this.logger.info("JBossPlugin disabled");
            }
            return;
        }
        if (this.isInfo) {
            this.logger.info("JBossPlugin config:{}", (Object)jbossConfig);
        }
        JbossDetector jbossDetector = new JbossDetector(jbossConfig.getBootstrapMains());
        context.addApplicationTypeDetector(new ApplicationTypeDetector[]{jbossDetector});
        if (this.shouldAddTransformers(jbossConfig)) {
            if (this.isInfo) {
                this.logger.info("Adding JBoss transformers");
            }
            this.addTransformers(jbossConfig);
        } else if (this.isInfo) {
            this.logger.info("Not adding JBoss transformers");
        }
    }

    private boolean shouldAddTransformers(JbossConfig jbossConfig) {
        if (!jbossConfig.isConditionalTransformEnable()) {
            return true;
        }
        ConditionProvider conditionProvider = ConditionProvider.DEFAULT_CONDITION_PROVIDER;
        boolean isJbossApplication = conditionProvider.checkMainClass(jbossConfig.getBootstrapMains());
        return isJbossApplication;
    }

    private void addTransformers(JbossConfig jbossConfig) {
        if (jbossConfig.isTraceEjb()) {
            this.addMethodInvocationMessageHandlerEditor();
        } else {
            this.addRequestEditor();
            this.addContextInvocationEditor();
            this.requestFacade(jbossConfig);
            this.addStandardHostValveEditor();
        }
    }

    private void requestFacade(final JbossConfig jbossConfig) {
        this.transformTemplate.transform("org.apache.catalina.connector.RequestFacade", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                if (jbossConfig.isHidePinpointHeader()) {
                    target.weave("com.navercorp.pinpoint.plugin.jboss.aspect.RequestFacadeAspect");
                }
                return target.toBytecode();
            }
        });
    }

    private void addRequestEditor() {
        this.transformTemplate.transform("org.apache.catalina.connector.Request", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                InstrumentMethod startAsyncMethodEditor = target.getDeclaredMethod("startAsync", new String[]{"javax.servlet.ServletRequest", "javax.servlet.ServletResponse"});
                if (startAsyncMethodEditor != null) {
                    startAsyncMethodEditor.addInterceptor("com.navercorp.pinpoint.plugin.jboss.interceptor.RequestStartAsyncInterceptor");
                }
                return target.toBytecode();
            }
        });
    }

    private void addMethodInvocationMessageHandlerEditor() {
        this.transformTemplate.transform("org.jboss.as.ejb3.remote.protocol.versionone.MethodInvocationMessageHandler", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                InstrumentMethod method = target.getDeclaredMethod("invokeMethod", new String[]{"short", "org.jboss.as.ee.component.ComponentView", "java.lang.reflect.Method", "java.lang.Object[]", "org.jboss.ejb.client.EJBLocator", "java.util.Map"});
                if (method != null) {
                    method.addInterceptor("com.navercorp.pinpoint.plugin.jboss.interceptor.MethodInvocationHandlerInterceptor");
                }
                return target.toBytecode();
            }
        });
    }

    private void addContextInvocationEditor() {
        this.transformTemplate.transform("org.jboss.as.ejb3.tx.EjbBMTInterceptor", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                InstrumentMethod method = target.getDeclaredMethod("handleInvocation", new String[]{"org.jboss.invocation.InterceptorContext"});
                if (method != null) {
                    method.addInterceptor("com.navercorp.pinpoint.plugin.jboss.interceptor.ContextInvocationInterceptor");
                }
                return target.toBytecode();
            }
        });
    }

    private void addStandardHostValveEditor() {
        this.transformTemplate.transform("org.apache.catalina.core.StandardHostValve", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                InstrumentMethod invokeMethod = target.getDeclaredMethod("invoke", new String[]{"org.apache.catalina.connector.Request", "org.apache.catalina.connector.Response"});
                if (invokeMethod != null) {
                    invokeMethod.addInterceptor("com.navercorp.pinpoint.plugin.jboss.interceptor.StandardHostValveInvokeInterceptor");
                }
                return target.toBytecode();
            }
        });
    }

    public void setTransformTemplate(TransformTemplate transformTemplate) {
        this.transformTemplate = transformTemplate;
    }
}

