/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.plugin.request.util;

import com.navercorp.pinpoint.bootstrap.config.DumpType;
import com.navercorp.pinpoint.bootstrap.config.HttpDumpConfig;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.request.util.EntityExtractor;
import com.navercorp.pinpoint.bootstrap.plugin.request.util.EntityRecorder;
import com.navercorp.pinpoint.bootstrap.util.InterceptorUtils;
import com.navercorp.pinpoint.common.trace.AnnotationKey;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.common.util.StringUtils;

public class DefaultEntityRecorder<T>
implements EntityRecorder<T> {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final HttpDumpConfig httpDumpConfig;
    private final EntityExtractor<T> entityExtractor;

    public DefaultEntityRecorder(HttpDumpConfig httpDumpConfig, EntityExtractor<T> entityExtractor) {
        this.httpDumpConfig = Assert.requireNonNull(httpDumpConfig, "httpDumpConfig must not be null");
        this.entityExtractor = Assert.requireNonNull(entityExtractor, "entityExtractor must not be null");
    }

    @Override
    public void record(SpanEventRecorder recorder, T entity, Throwable throwable) {
        if (DumpType.ALWAYS == this.httpDumpConfig.getEntityDumpType()) {
            this.recordEntity(recorder, entity);
        } else if (DumpType.EXCEPTION == this.httpDumpConfig.getEntityDumpType() && InterceptorUtils.isThrowable(throwable)) {
            this.recordEntity(recorder, entity);
        }
    }

    private void recordEntity(SpanEventRecorder recorder, T entity) {
        String entityValue;
        if (this.httpDumpConfig.getEntitySampler().isSampling() && (entityValue = this.entityExtractor.getEntity(entity)) != null) {
            int entityDumpSize = this.httpDumpConfig.getEntityDumpSize();
            String entityString = StringUtils.abbreviate(entityValue, entityDumpSize);
            recorder.recordAttribute(AnnotationKey.HTTP_PARAM_ENTITY, entityString);
            if (this.isDebug) {
                this.logger.debug("Record entity={}", (Object)entityValue);
            }
        }
    }
}

