/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.okhttp.v3.interceptor;

import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.context.TraceId;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.InterceptorScope;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.InterceptorScopeInvocation;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.request.ClientHeaderAdaptor;
import com.navercorp.pinpoint.bootstrap.plugin.request.DefaultRequestTraceWriter;
import com.navercorp.pinpoint.bootstrap.plugin.request.RequestTraceWriter;
import com.navercorp.pinpoint.common.plugin.util.HostAndPort;
import com.navercorp.pinpoint.plugin.okhttp.EndPointUtils;
import com.navercorp.pinpoint.plugin.okhttp.v3.HttpUrlGetter;
import com.navercorp.pinpoint.plugin.okhttp.v3.RequestBuilder3ClientHeaderAdaptor;
import okhttp3.HttpUrl;
import okhttp3.Request;

public class RequestBuilderBuildMethodInterceptor
implements AroundInterceptor {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final TraceContext traceContext;
    private final MethodDescriptor methodDescriptor;
    private final InterceptorScope interceptorScope;
    private final RequestTraceWriter<Request.Builder> requestTraceWriter;

    public RequestBuilderBuildMethodInterceptor(TraceContext traceContext, MethodDescriptor methodDescriptor, InterceptorScope interceptorScope) {
        this.traceContext = traceContext;
        this.methodDescriptor = methodDescriptor;
        this.interceptorScope = interceptorScope;
        RequestBuilder3ClientHeaderAdaptor clientHeaderAdaptor = new RequestBuilder3ClientHeaderAdaptor();
        this.requestTraceWriter = new DefaultRequestTraceWriter((ClientHeaderAdaptor)clientHeaderAdaptor, traceContext);
    }

    public void before(Object target, Object[] args) {
        Trace trace;
        if (this.isDebug) {
            this.logger.beforeInterceptor(target, args);
        }
        if ((trace = this.traceContext.currentRawTraceObject()) == null) {
            return;
        }
        try {
            if (!(target instanceof Request.Builder)) {
                return;
            }
            Request.Builder builder = (Request.Builder)target;
            if (!trace.canSampled()) {
                if (builder != null) {
                    this.requestTraceWriter.write((Object)builder);
                }
                return;
            }
            InterceptorScopeInvocation invocation = this.interceptorScope.getCurrentInvocation();
            Object attachment = this.getAttachment(invocation);
            if (!(attachment instanceof TraceId)) {
                if (this.isDebug) {
                    this.logger.debug("Invalid interceptor scope invocation. {}", (Object)invocation);
                }
                return;
            }
            TraceId nextId = (TraceId)attachment;
            String host = this.getHost(target);
            this.requestTraceWriter.write((Object)builder, nextId, host);
        }
        catch (Throwable t) {
            this.logger.warn("Failed to BEFORE process. {}", (Object)t.getMessage(), (Object)t);
        }
    }

    private Object getAttachment(InterceptorScopeInvocation invocation) {
        if (invocation == null) {
            return null;
        }
        return invocation.getAttachment();
    }

    private String getHost(Object target) {
        HttpUrl url;
        if (target instanceof HttpUrlGetter && (url = ((HttpUrlGetter)target)._$PINPOINT$_getHttpUrl()) != null) {
            return this.getDestinationId(url);
        }
        return null;
    }

    private String getDestinationId(HttpUrl httpUrl) {
        if (httpUrl == null || httpUrl.host() == null) {
            return "Unknown";
        }
        int port = EndPointUtils.getPort(httpUrl.port(), HttpUrl.defaultPort((String)httpUrl.scheme()));
        return HostAndPort.toHostAndPortString((String)httpUrl.host(), (int)port);
    }

    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        if (this.isDebug) {
            this.logger.afterInterceptor(target, args);
        }
    }
}

