/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.test;

import com.navercorp.pinpoint.exception.PinpointException;
import com.navercorp.pinpoint.profiler.instrument.classloading.ClassInjector;
import java.io.InputStream;

public class TestProfilerPluginClassLoader
implements ClassInjector {
    public <T> Class<? extends T> injectClass(ClassLoader targetClassLoader, String className) {
        try {
            return Class.forName(className, false, targetClassLoader);
        }
        catch (ClassNotFoundException e) {
            throw new PinpointException("Cannot find class: " + className, (Throwable)e);
        }
    }

    public InputStream getResourceAsStream(ClassLoader targetClassLoader, String internalName) {
        targetClassLoader = TestProfilerPluginClassLoader.getClassLoader(targetClassLoader);
        return targetClassLoader.getResourceAsStream(internalName);
    }

    private static ClassLoader getClassLoader(ClassLoader classLoader) {
        if (classLoader == null) {
            return ClassLoader.getSystemClassLoader();
        }
        return classLoader;
    }
}

