/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.httpclient4.interceptor;

import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.InterceptorScope;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.InterceptorScopeInvocation;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.pair.NameIntValuePair;
import com.navercorp.pinpoint.plugin.httpclient4.HttpCallContext;
import com.navercorp.pinpoint.plugin.httpclient4.HttpCallContextFactory;
import com.navercorp.pinpoint.plugin.httpclient4.HttpClient4Constants;
import org.apache.http.HttpRequest;

public abstract class AbstractHttpClientExecuteMethodInterceptor
implements AroundInterceptor {
    protected final PLogger logger;
    protected final boolean isDebug;
    private boolean isHasCallbackParam;
    protected final TraceContext traceContext;
    protected final MethodDescriptor descriptor;
    protected final InterceptorScope interceptorScope;

    public AbstractHttpClientExecuteMethodInterceptor(Class<? extends AbstractHttpClientExecuteMethodInterceptor> childClazz, boolean isHasCallbackParam, TraceContext context, MethodDescriptor methodDescriptor, InterceptorScope interceptorScope) {
        this.logger = PLoggerFactory.getLogger(childClazz);
        this.isDebug = this.logger.isDebugEnabled();
        this.traceContext = context;
        this.descriptor = methodDescriptor;
        this.isHasCallbackParam = isHasCallbackParam;
        this.interceptorScope = interceptorScope;
    }

    abstract NameIntValuePair<String> getHost(Object[] var1);

    abstract HttpRequest getHttpRequest(Object[] var1);

    public void before(Object target, Object[] args) {
        InterceptorScopeInvocation invocation;
        Trace trace;
        if (this.isDebug) {
            this.logger.beforeInterceptor(target, args);
        }
        if ((trace = this.traceContext.currentTraceObject()) == null) {
            return;
        }
        SpanEventRecorder recorder = trace.traceBlockBegin();
        recorder.recordServiceType(HttpClient4Constants.HTTP_CLIENT_4_INTERNAL);
        NameIntValuePair<String> host = this.getHost(args);
        if (host != null && (invocation = this.interceptorScope.getCurrentInvocation()) != null) {
            HttpCallContext callContext = (HttpCallContext)invocation.getOrCreateAttachment(HttpCallContextFactory.HTTPCALL_CONTEXT_FACTORY);
            callContext.setHost((String)host.getName());
            callContext.setPort(host.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        Trace trace;
        if (this.isDebug) {
            this.logger.afterInterceptor(target, args);
        }
        if ((trace = this.traceContext.currentTraceObject()) == null) {
            return;
        }
        try {
            SpanEventRecorder recorder = trace.currentSpanEventRecorder();
            recorder.recordApi(this.descriptor);
            recorder.recordException(throwable);
            InterceptorScopeInvocation invocation = this.interceptorScope.getCurrentInvocation();
            if (invocation != null) {
                invocation.removeAttachment();
            }
        }
        finally {
            trace.traceBlockEnd();
        }
    }
}

