/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.ibatis;

import com.navercorp.pinpoint.bootstrap.instrument.InstrumentClass;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentException;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentMethod;
import com.navercorp.pinpoint.bootstrap.instrument.Instrumentor;
import com.navercorp.pinpoint.bootstrap.instrument.MethodFilter;
import com.navercorp.pinpoint.bootstrap.instrument.MethodFilters;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformCallback;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplate;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplateAware;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.ExecutionPolicy;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPlugin;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPluginSetupContext;
import com.navercorp.pinpoint.common.trace.ServiceType;
import com.navercorp.pinpoint.common.util.VarArgs;
import com.navercorp.pinpoint.plugin.ibatis.IBatisConstants;
import com.navercorp.pinpoint.plugin.ibatis.IBatisPluginConfig;
import java.security.ProtectionDomain;
import java.util.List;

public class IBatisPlugin
implements ProfilerPlugin,
TransformTemplateAware {
    private static final String IBATIS_SCOPE = "IBATIS_SCOPE";
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private TransformTemplate transformTemplate;

    public void setup(ProfilerPluginSetupContext context) {
        IBatisPluginConfig iBatisPluginConfig = new IBatisPluginConfig(context.getConfig());
        if (this.logger.isInfoEnabled()) {
            this.logger.info("IBatisPlugin config:{}", (Object)iBatisPluginConfig);
        }
        if (iBatisPluginConfig.isIBatisEnabled()) {
            this.addInterceptorsForSqlMapExecutors();
            this.addInterceptorsForSqlMapClientTemplate();
        }
    }

    private void addInterceptorsForSqlMapExecutors() {
        ServiceType serviceType = IBatisConstants.IBATIS;
        String[] sqlMapExecutorImplClasses = new String[]{"com.ibatis.sqlmap.engine.impl.SqlMapClientImpl", "com.ibatis.sqlmap.engine.impl.SqlMapSessionImpl"};
        this.addInterceptorsForClasses(serviceType, sqlMapExecutorImplClasses);
    }

    private void addInterceptorsForSqlMapClientTemplate() {
        ServiceType serviceType = IBatisConstants.IBATIS_SPRING;
        String[] sqlMapClientTemplateClasses = new String[]{"org.springframework.orm.ibatis.SqlMapClientTemplate"};
        this.addInterceptorsForClasses(serviceType, sqlMapClientTemplateClasses);
    }

    private void addInterceptorsForClasses(ServiceType serviceType, String ... targetClassNames) {
        MethodFilter methodFilter = MethodFilters.name((String[])new String[]{"insert", "delete", "update", "queryForList", "queryForMap", "queryForObject", "queryForPaginatedList"});
        for (String targetClassName : targetClassNames) {
            this.addInterceptorsForClass(targetClassName, serviceType, methodFilter);
        }
    }

    private void addInterceptorsForClass(String targetClassName, final ServiceType serviceType, final MethodFilter methodFilter) {
        this.transformTemplate.transform(targetClassName, new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                List methodsToTrace = target.getDeclaredMethods(methodFilter);
                for (InstrumentMethod methodToTrace : methodsToTrace) {
                    String sqlMapOperationInterceptor = "com.navercorp.pinpoint.plugin.ibatis.interceptor.SqlMapOperationInterceptor";
                    methodToTrace.addScopedInterceptor(sqlMapOperationInterceptor, VarArgs.va((Object[])new Object[]{serviceType}), IBatisPlugin.IBATIS_SCOPE, ExecutionPolicy.BOUNDARY);
                }
                return target.toBytecode();
            }
        });
    }

    public void setTransformTemplate(TransformTemplate transformTemplate) {
        this.transformTemplate = transformTemplate;
    }
}

