/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.websphere;

import com.ibm.websphere.servlet.request.IRequest;
import com.navercorp.pinpoint.bootstrap.plugin.request.util.ParameterExtractor;
import com.navercorp.pinpoint.common.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.LinkedHashMap;
import java.util.Map;

public class IRequestParameterExtractor
implements ParameterExtractor<IRequest> {
    private int eachLimit;
    private int totalLimit;

    public IRequestParameterExtractor(int eachLimit, int totalLimit) {
        this.eachLimit = eachLimit;
        this.totalLimit = totalLimit;
    }

    public String extractParameter(IRequest request) {
        String queryString = request.getQueryString();
        StringBuilder params = new StringBuilder(64);
        try {
            Map<String, String> query_pairs = this.splitQuery(queryString);
            for (Map.Entry<String, String> entry : query_pairs.entrySet()) {
                if (params.length() != 0) {
                    params.append('&');
                }
                if (params.length() > this.totalLimit) {
                    params.append("...");
                    return params.toString();
                }
                String key = entry.getKey();
                params.append(StringUtils.abbreviate((String)key, (int)this.eachLimit));
                params.append('=');
                String value = entry.getValue();
                if (value == null) continue;
                params.append(StringUtils.abbreviate((String)StringUtils.toString((Object)value), (int)this.eachLimit));
            }
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        return params.toString();
    }

    private Map<String, String> splitQuery(String query) throws UnsupportedEncodingException {
        LinkedHashMap<String, String> query_pairs = new LinkedHashMap<String, String>();
        if (query != null) {
            String[] pairs;
            for (String pair : pairs = query.split("&")) {
                int idx = pair.indexOf(61);
                query_pairs.put(URLDecoder.decode(pair.substring(0, idx), "UTF-8"), URLDecoder.decode(pair.substring(idx + 1), "UTF-8"));
            }
        }
        return query_pairs;
    }
}

