/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.thrift.interceptor.server.async;

import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.InterceptorScope;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.InterceptorScopeInvocation;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.plugin.thrift.ThriftClientCallContext;
import com.navercorp.pinpoint.plugin.thrift.ThriftUtils;
import com.navercorp.pinpoint.plugin.thrift.field.accessor.AsyncMarkerFlagFieldAccessor;
import com.navercorp.pinpoint.plugin.thrift.field.accessor.ServerMarkerFlagFieldAccessor;
import org.apache.thrift.TBaseAsyncProcessor;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.server.AbstractNonblockingServer;

public class TBaseAsyncProcessorProcessInterceptor
implements AroundInterceptor {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final TraceContext traceContext;
    private final MethodDescriptor descriptor;
    private final InterceptorScope scope;

    public TBaseAsyncProcessorProcessInterceptor(TraceContext traceContext, MethodDescriptor descriptor, InterceptorScope scope) {
        this.traceContext = traceContext;
        this.descriptor = descriptor;
        this.scope = scope;
    }

    public void before(Object target, Object[] args) {
        if (this.isDebug) {
            this.logger.beforeInterceptor(target, args);
        }
        if (args.length != 1) {
            return;
        }
        if (args[0] instanceof AbstractNonblockingServer.AsyncFrameBuffer) {
            AbstractNonblockingServer.AsyncFrameBuffer frameBuffer = (AbstractNonblockingServer.AsyncFrameBuffer)args[0];
            this.attachMarkersToInputProtocol(frameBuffer.getInputProtocol(), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        Trace trace;
        if (this.isDebug) {
            this.logger.afterInterceptor(target, args, result, throwable);
        }
        if (args[0] instanceof AbstractNonblockingServer.AsyncFrameBuffer) {
            AbstractNonblockingServer.AsyncFrameBuffer frameBuffer = (AbstractNonblockingServer.AsyncFrameBuffer)args[0];
            this.attachMarkersToInputProtocol(frameBuffer.getInputProtocol(), false);
        }
        if ((trace = this.traceContext.currentRawTraceObject()) == null) {
            return;
        }
        this.traceContext.removeTraceObject();
        if (trace.canSampled()) {
            try {
                this.processTraceObject(trace, target, args, throwable);
            }
            catch (Throwable t) {
                this.logger.warn("Error processing trace object. Cause:{}", (Object)t.getMessage(), (Object)t);
            }
            finally {
                trace.close();
            }
        }
    }

    private boolean validateInputProtocol(Object iprot) {
        if (iprot instanceof TProtocol) {
            if (!(iprot instanceof ServerMarkerFlagFieldAccessor)) {
                if (this.isDebug) {
                    this.logger.debug("Invalid target object. Need field accessor({}).", (Object)ServerMarkerFlagFieldAccessor.class.getName());
                }
                return false;
            }
            if (!(iprot instanceof AsyncMarkerFlagFieldAccessor)) {
                if (this.isDebug) {
                    this.logger.debug("Invalid target object. Need field accessor({}).", (Object)AsyncMarkerFlagFieldAccessor.class.getName());
                }
                return false;
            }
            return true;
        }
        return false;
    }

    private void attachMarkersToInputProtocol(TProtocol iprot, boolean flag) {
        if (this.validateInputProtocol(iprot)) {
            ((ServerMarkerFlagFieldAccessor)iprot)._$PINPOINT$_setServerMarkerFlag(flag);
            ((AsyncMarkerFlagFieldAccessor)iprot)._$PINPOINT$_setAsyncMarkerFlag(flag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTraceObject(Trace trace, Object target, Object[] args, Throwable throwable) {
        SpanEventRecorder recorder;
        try {
            recorder = trace.currentSpanEventRecorder();
            recorder.recordException(throwable);
            recorder.recordApi(this.descriptor);
        }
        catch (Throwable t) {
            this.logger.warn("Error processing trace object. Cause:{}", (Object)t.getMessage(), (Object)t);
        }
        finally {
            trace.traceBlockEnd();
        }
        recorder = trace.getSpanRecorder();
        String methodUri = this.getMethodUri(target);
        recorder.recordRpcName(methodUri);
    }

    private String getMethodUri(Object target) {
        String methodUri = "/unknown";
        InterceptorScopeInvocation currentTransaction = this.scope.getCurrentInvocation();
        Object attachment = currentTransaction.getAttachment();
        if (attachment instanceof ThriftClientCallContext && target instanceof TBaseAsyncProcessor) {
            ThriftClientCallContext clientCallContext = (ThriftClientCallContext)attachment;
            String methodName = clientCallContext.getMethodName();
            methodUri = ThriftUtils.getAsyncProcessorNameAsUri((TBaseAsyncProcessor)target);
            StringBuilder sb = new StringBuilder(methodUri);
            if (!methodUri.endsWith("/")) {
                sb.append("/");
            }
            sb.append(methodName);
            methodUri = sb.toString();
        }
        return methodUri;
    }
}

