/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.thrift.interceptor.server;

import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.SpanRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.InterceptorScope;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.InterceptorScopeInvocation;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.plugin.thrift.ThriftClientCallContext;
import com.navercorp.pinpoint.plugin.thrift.ThriftConstants;
import com.navercorp.pinpoint.plugin.thrift.ThriftUtils;
import org.apache.thrift.TBaseProcessor;

public class TBaseProcessorProcessInterceptor
implements AroundInterceptor {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final TraceContext traceContext;
    private final MethodDescriptor descriptor;
    private final InterceptorScope scope;

    public TBaseProcessorProcessInterceptor(TraceContext traceContext, MethodDescriptor descriptor, InterceptorScope scope) {
        this.traceContext = traceContext;
        this.descriptor = descriptor;
        this.scope = scope;
    }

    public void before(Object target, Object[] args) {
    }

    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        ThriftClientCallContext clientCallContext;
        Trace trace = this.traceContext.currentRawTraceObject();
        if (trace == null) {
            return;
        }
        InterceptorScopeInvocation currentTransaction = this.scope.getCurrentInvocation();
        Object attachment = currentTransaction.getAttachment();
        if (!(attachment instanceof ThriftClientCallContext)) {
            return;
        }
        if (this.isDebug) {
            this.logger.afterInterceptor(target, args, result, throwable);
        }
        if ((clientCallContext = (ThriftClientCallContext)attachment).isEntryPoint()) {
            this.traceContext.removeTraceObject();
        }
        if (trace.canSampled()) {
            String methodUri = this.getMethodUri(target);
            if (clientCallContext.isEntryPoint()) {
                this.finalizeSpan(trace, methodUri, throwable);
            } else {
                this.finalizeSpanEvent(trace, methodUri, throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finalizeSpan(Trace trace, String methodUri, Throwable throwable) {
        try {
            this.finalizeSpanEvent(trace, null, throwable);
            SpanRecorder recorder = trace.getSpanRecorder();
            recorder.recordRpcName(methodUri);
        }
        catch (Throwable t) {
            this.logger.warn("Error processing trace object. Cause:{}", (Object)t.getMessage(), (Object)t);
        }
        finally {
            trace.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finalizeSpanEvent(Trace trace, String methodUri, Throwable throwable) {
        try {
            SpanEventRecorder recorder = trace.currentSpanEventRecorder();
            recorder.recordException(throwable);
            recorder.recordApi(this.descriptor);
            if (methodUri != null) {
                recorder.recordAttribute(ThriftConstants.THRIFT_URL, methodUri);
            }
        }
        catch (Throwable t) {
            this.logger.warn("Error processing trace object. Cause:{}", (Object)t.getMessage(), (Object)t);
        }
        finally {
            trace.traceBlockEnd();
        }
    }

    private String getMethodUri(Object target) {
        String methodUri = "/unknown";
        InterceptorScopeInvocation currentTransaction = this.scope.getCurrentInvocation();
        Object attachment = currentTransaction.getAttachment();
        if (attachment instanceof ThriftClientCallContext && target instanceof TBaseProcessor) {
            ThriftClientCallContext clientCallContext = (ThriftClientCallContext)attachment;
            String methodName = clientCallContext.getMethodName();
            methodUri = ThriftUtils.getProcessorNameAsUri((TBaseProcessor)target);
            StringBuilder sb = new StringBuilder(methodUri);
            if (!methodUri.endsWith("/")) {
                sb.append("/");
            }
            sb.append(methodName);
            methodUri = sb.toString();
        }
        return methodUri;
    }
}

