/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.activemq.client;

import com.navercorp.pinpoint.bootstrap.async.AsyncContextAccessor;
import com.navercorp.pinpoint.bootstrap.config.Filter;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentClass;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentException;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentMethod;
import com.navercorp.pinpoint.bootstrap.instrument.Instrumentor;
import com.navercorp.pinpoint.bootstrap.instrument.MethodFilter;
import com.navercorp.pinpoint.bootstrap.instrument.MethodFilters;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformCallback;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplate;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplateAware;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPlugin;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPluginSetupContext;
import com.navercorp.pinpoint.common.util.VarArgs;
import com.navercorp.pinpoint.plugin.activemq.client.ActiveMQClientPluginConfig;
import java.security.ProtectionDomain;

public class ActiveMQClientPlugin
implements ProfilerPlugin,
TransformTemplateAware {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private TransformTemplate transformTemplate;

    public void setup(ProfilerPluginSetupContext context) {
        ActiveMQClientPluginConfig config = new ActiveMQClientPluginConfig(context.getConfig());
        if (!config.isTraceActiveMQClient()) {
            return;
        }
        if (config.isTraceActiveMQClientConsumer() || config.isTraceActiveMQClientProducer()) {
            this.addTransportEditor();
            this.addConnectionEditor();
            Filter<String> excludeDestinationFilter = config.getExcludeDestinationFilter();
            if (config.isTraceActiveMQClientProducer()) {
                this.addProducerEditor(excludeDestinationFilter);
            }
            if (config.isTraceActiveMQClientConsumer()) {
                boolean traceActiveMQTextMessage = config.isTraceActiveMQTextMessage();
                this.addConsumerEditor(traceActiveMQTextMessage, excludeDestinationFilter);
            }
        }
    }

    private void addTransportEditor() {
        this.transformTemplate.transform("org.apache.activemq.transport.failover.FailoverTransport", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                target.addGetter("com.navercorp.pinpoint.plugin.activemq.client.field.getter.URIGetter", "connectedTransportURI");
                return target.toBytecode();
            }
        });
        this.transformTemplate.transform("org.apache.activemq.transport.tcp.TcpTransport", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                target.addGetter("com.navercorp.pinpoint.plugin.activemq.client.field.getter.SocketGetter", "socket");
                return target.toBytecode();
            }
        });
    }

    private void addConnectionEditor() {
        this.transformTemplate.transform("org.apache.activemq.ActiveMQConnection", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                target.addGetter("com.navercorp.pinpoint.plugin.activemq.client.field.getter.TransportGetter", "transport");
                return target.toBytecode();
            }
        });
    }

    private void addProducerEditor(final Filter<String> excludeDestinationFilter) {
        final MethodFilter methodFilter = MethodFilters.chain((MethodFilter[])new MethodFilter[]{MethodFilters.name((String[])new String[]{"send"}), MethodFilters.argAt((int)0, (String)"javax.jms.Destination"), MethodFilters.argAt((int)1, (String)"javax.jms.Message")});
        this.transformTemplate.transform("org.apache.activemq.ActiveMQMessageProducer", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                target.addGetter("com.navercorp.pinpoint.plugin.activemq.client.field.getter.ActiveMQSessionGetter", "session");
                for (InstrumentMethod method : target.getDeclaredMethods(methodFilter)) {
                    try {
                        method.addScopedInterceptor("com.navercorp.pinpoint.plugin.activemq.client.interceptor.ActiveMQMessageProducerSendInterceptor", VarArgs.va((Object[])new Object[]{excludeDestinationFilter}), "ActiveMQClientScope");
                    }
                    catch (Exception e) {
                        if (!ActiveMQClientPlugin.this.logger.isWarnEnabled()) continue;
                        ActiveMQClientPlugin.this.logger.warn("Unsupported method " + method, (Throwable)e);
                    }
                }
                return target.toBytecode();
            }
        });
    }

    private void addConsumerEditor(final boolean traceActiveMQTextMessage, final Filter<String> excludeDestinationFilter) {
        this.transformTemplate.transform("org.apache.activemq.ActiveMQMessageConsumer", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentMethod createActiveMQMessage;
                InstrumentMethod receiveNoWait;
                InstrumentMethod receiveWithParam;
                InstrumentMethod receive;
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                target.addGetter("com.navercorp.pinpoint.plugin.activemq.client.field.getter.ActiveMQSessionGetter", "session");
                InstrumentMethod dispatchMethod = target.getDeclaredMethod("dispatch", new String[]{"org.apache.activemq.command.MessageDispatch"});
                if (dispatchMethod != null) {
                    dispatchMethod.addScopedInterceptor("com.navercorp.pinpoint.plugin.activemq.client.interceptor.ActiveMQMessageConsumerDispatchInterceptor", VarArgs.va((Object[])new Object[]{excludeDestinationFilter}), "ActiveMQClientScope");
                }
                if ((receive = target.getDeclaredMethod("receive", new String[0])) != null) {
                    receive.addScopedInterceptor("com.navercorp.pinpoint.plugin.activemq.client.interceptor.ActiveMQMessageConsumerReceiveInterceptor", VarArgs.va((Object[])new Object[]{traceActiveMQTextMessage}), "ActiveMQClientScope");
                }
                if ((receiveWithParam = target.getDeclaredMethod("receive", new String[]{"long"})) != null) {
                    receiveWithParam.addScopedInterceptor("com.navercorp.pinpoint.plugin.activemq.client.interceptor.ActiveMQMessageConsumerReceiveInterceptor", VarArgs.va((Object[])new Object[]{traceActiveMQTextMessage}), "ActiveMQClientScope");
                }
                if ((receiveNoWait = target.getDeclaredMethod("receiveNoWait", new String[0])) != null) {
                    receiveNoWait.addScopedInterceptor("com.navercorp.pinpoint.plugin.activemq.client.interceptor.ActiveMQMessageConsumerReceiveInterceptor", VarArgs.va((Object[])new Object[]{traceActiveMQTextMessage}), "ActiveMQClientScope");
                }
                if ((createActiveMQMessage = target.getDeclaredMethod("createActiveMQMessage", new String[]{"org.apache.activemq.command.MessageDispatch"})) != null) {
                    createActiveMQMessage.addInterceptor("com.navercorp.pinpoint.plugin.activemq.client.interceptor.ActiveMQMessageConsumerCreateActiveMQMessageInterceptor");
                }
                return target.toBytecode();
            }
        });
        this.transformTemplate.transform("org.apache.activemq.command.MessageDispatch", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                target.addField(AsyncContextAccessor.class.getName());
                return target.toBytecode();
            }
        });
        this.transformTemplate.transform("org.apache.activemq.command.ActiveMQMessage", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                target.addField(AsyncContextAccessor.class.getName());
                return target.toBytecode();
            }
        });
    }

    public void setTransformTemplate(TransformTemplate transformTemplate) {
        this.transformTemplate = transformTemplate;
    }
}

