/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.weblogic;

import com.navercorp.pinpoint.bootstrap.plugin.ApplicationTypeDetector;
import com.navercorp.pinpoint.bootstrap.resolver.ConditionProvider;
import com.navercorp.pinpoint.common.trace.ServiceType;
import com.navercorp.pinpoint.plugin.weblogic.WeblogicConstants;
import java.util.Arrays;
import java.util.List;

public class WeblogicDetector
implements ApplicationTypeDetector {
    private static final String DEFAULT_BOOTSTRAP_MAIN = "weblogic.Server";
    private final List<String> bootstrapMains;

    public WeblogicDetector(List<String> bootstrapMains) {
        this.bootstrapMains = bootstrapMains == null || bootstrapMains.isEmpty() ? Arrays.asList(DEFAULT_BOOTSTRAP_MAIN) : bootstrapMains;
    }

    public ServiceType getApplicationType() {
        return WeblogicConstants.WEBLOGIC;
    }

    public boolean detect(ConditionProvider provider) {
        return provider.checkMainClass(this.bootstrapMains);
    }
}

