/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.undertowservlet;

import com.navercorp.pinpoint.bootstrap.instrument.InstrumentClass;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentException;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentMethod;
import com.navercorp.pinpoint.bootstrap.instrument.Instrumentor;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformCallback;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplate;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplateAware;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPlugin;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPluginSetupContext;
import com.navercorp.pinpoint.plugin.undertowservlet.UndertowServletConfig;
import java.security.ProtectionDomain;

public class UndertowServletPlugin
implements ProfilerPlugin,
TransformTemplateAware {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private TransformTemplate transformTemplate;

    public void setup(ProfilerPluginSetupContext context) {
        UndertowServletConfig config = new UndertowServletConfig(context.getConfig());
        if (!config.isEnable()) {
            this.logger.info("UndertowServletPlugin disabled");
            return;
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("UndertowServletPlugin config:{}", (Object)config);
        }
        this.addHttpServletRequestImpl();
    }

    private void addHttpServletRequestImpl() {
        this.transformTemplate.transform("io.undertow.servlet.spec.HttpServletRequestImpl", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(classLoader, className, classfileBuffer);
                InstrumentMethod startAsyncMethod = target.getDeclaredMethod("startAsync", new String[]{"javax.servlet.ServletRequest", "javax.servlet.ServletResponse"});
                if (startAsyncMethod != null) {
                    startAsyncMethod.addInterceptor("com.navercorp.pinpoint.plugin.undertowservlet.interceptor.HttpServletRequestImplStartAsyncInterceptor");
                }
                return target.toBytecode();
            }
        });
    }

    public void setTransformTemplate(TransformTemplate transformTemplate) {
        this.transformTemplate = transformTemplate;
    }
}

