/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.vertx.interceptor;

import com.navercorp.pinpoint.bootstrap.async.AsyncContextAccessor;
import com.navercorp.pinpoint.bootstrap.context.AsyncContext;
import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.plugin.vertx.VertxConstants;

public class ContextImplRunOnContextInterceptor
implements AroundInterceptor {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private TraceContext traceContext;
    private MethodDescriptor descriptor;

    public ContextImplRunOnContextInterceptor(TraceContext traceContext, MethodDescriptor methodDescriptor) {
        this.traceContext = traceContext;
        this.descriptor = methodDescriptor;
    }

    public void before(Object target, Object[] args) {
        Trace trace;
        if (this.isDebug) {
            this.logger.beforeInterceptor(target, args);
        }
        if ((trace = this.traceContext.currentTraceObject()) == null) {
            return;
        }
        SpanEventRecorder recorder = trace.traceBlockBegin();
        recorder.recordServiceType(VertxConstants.VERTX_INTERNAL);
        if (this.validate(args)) {
            AsyncContext asyncContext = recorder.recordNextAsyncContext();
            ((AsyncContextAccessor)args[0])._$PINPOINT$_setAsyncContext(asyncContext);
            if (this.isDebug) {
                this.logger.debug("Set asyncContext {}", (Object)asyncContext);
            }
        }
    }

    private boolean validate(Object[] args) {
        if (args == null || args.length < 1) {
            if (this.isDebug) {
                this.logger.debug("Invalid args object. args={}.", args);
            }
            return false;
        }
        if (!(args[0] instanceof AsyncContextAccessor)) {
            if (this.isDebug) {
                this.logger.debug("Invalid args[0] object. Need metadata accessor({}).", (Object)AsyncContextAccessor.class.getName());
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        Trace trace;
        if (this.isDebug) {
            this.logger.afterInterceptor(target, args, result, throwable);
        }
        if ((trace = this.traceContext.currentTraceObject()) == null) {
            return;
        }
        try {
            SpanEventRecorder recorder = trace.currentSpanEventRecorder();
            recorder.recordApi(this.descriptor);
            recorder.recordServiceType(VertxConstants.VERTX_INTERNAL);
            recorder.recordException(throwable);
        }
        finally {
            trace.traceBlockEnd();
        }
    }
}

