/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.httpclient3;

import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.request.ClientRequestWrapper;
import com.navercorp.pinpoint.common.plugin.util.HostAndPort;
import com.navercorp.pinpoint.common.util.Assert;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.protocol.Protocol;

public class HttpClient3RequestWrapper
implements ClientRequestWrapper {
    private static final int SKIP_DEFAULT_PORT = -1;
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final HttpMethod httpMethod;
    private final HttpConnection httpConnection;

    public HttpClient3RequestWrapper(HttpMethod httpMethod, HttpConnection httpConnection) {
        this.httpMethod = (HttpMethod)Assert.requireNonNull((Object)httpMethod, (String)"httpMethod must not be null");
        this.httpConnection = httpConnection;
    }

    public String getDestinationId() {
        try {
            URI uri = this.httpMethod.getURI();
            if (uri.isAbsoluteURI() || this.httpConnection == null) {
                return HttpClient3RequestWrapper.getEndpoint(uri.getHost(), uri.getPort());
            }
            String host = this.httpConnection.getHost();
            int port = HttpClient3RequestWrapper.getPort(this.httpConnection);
            return HttpClient3RequestWrapper.getEndpoint(host, port);
        }
        catch (Exception e) {
            if (this.isDebug) {
                this.logger.debug("Failed to get destinationId. httpMethod={}", (Object)this.httpMethod, (Object)e);
            }
            return "unknown";
        }
    }

    public String getUrl() {
        try {
            URI uri = this.httpMethod.getURI();
            if (uri.isAbsoluteURI() || this.httpConnection == null) {
                return uri.getURI();
            }
            String host = this.httpConnection.getHost();
            int port = HttpClient3RequestWrapper.getPort(this.httpConnection);
            return HttpClient3RequestWrapper.getHttpUrl(host, port, uri, this.httpConnection);
        }
        catch (Exception e) {
            if (this.isDebug) {
                this.logger.debug("Failed to get url. httpMethod={}", (Object)this.httpMethod, (Object)e);
            }
            return null;
        }
    }

    public static String getEndpoint(String host, int port) {
        if (host == null) {
            return "Unknown";
        }
        return HostAndPort.toHostAndPortString((String)host, (int)HostAndPort.getPortOrNoPort((int)port));
    }

    public static int getPort(HttpConnection httpConnection) {
        if (httpConnection == null) {
            return -1;
        }
        int port = httpConnection.getPort();
        Protocol protocol = httpConnection.getProtocol();
        if (protocol != null && port == protocol.getDefaultPort()) {
            return -1;
        }
        return port;
    }

    private static String getHttpUrl(String host, int port, URI uri, HttpConnection httpConnection) throws URIException {
        Protocol protocol = httpConnection.getProtocol();
        if (protocol == null) {
            return uri.getURI();
        }
        StringBuilder sb = new StringBuilder();
        String scheme = protocol.getScheme();
        sb.append(scheme).append("://");
        sb.append(host);
        if (port != -1) {
            sb.append(':').append(port);
        }
        sb.append(uri.getURI());
        return sb.toString();
    }
}

