/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.cassandra.interceptor;

import com.datastax.driver.core.RegularStatement;
import com.navercorp.pinpoint.bootstrap.context.DatabaseInfo;
import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.ParsingResult;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.SpanEventSimpleAroundInterceptorForPlugin;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.DatabaseInfoAccessor;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.ParsingResultAccessor;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.UnKnownDatabaseInfo;
import com.navercorp.pinpoint.bootstrap.util.InterceptorUtils;

public class CassandraPreparedStatementCreateInterceptor
extends SpanEventSimpleAroundInterceptorForPlugin {
    public CassandraPreparedStatementCreateInterceptor(TraceContext context, MethodDescriptor descriptor) {
        super(context, descriptor);
    }

    public void doInBeforeTrace(SpanEventRecorder recorder, Object target, Object[] args) {
        DatabaseInfo databaseInfo;
        DatabaseInfo databaseInfo2 = databaseInfo = target instanceof DatabaseInfoAccessor ? ((DatabaseInfoAccessor)target)._$PINPOINT$_getDatabaseInfo() : null;
        if (databaseInfo == null) {
            databaseInfo = UnKnownDatabaseInfo.INSTANCE;
        }
        recorder.recordServiceType(databaseInfo.getType());
        recorder.recordEndPoint(databaseInfo.getMultipleHost());
        recorder.recordDestinationId(databaseInfo.getDatabaseId());
    }

    protected void prepareAfterTrace(Object target, Object[] args, Object result, Throwable throwable) {
        boolean success = InterceptorUtils.isSuccess((Throwable)throwable);
        if (success) {
            DatabaseInfo databaseInfo;
            if (target instanceof DatabaseInfoAccessor && (databaseInfo = ((DatabaseInfoAccessor)target)._$PINPOINT$_getDatabaseInfo()) != null && result instanceof DatabaseInfoAccessor) {
                ((DatabaseInfoAccessor)result)._$PINPOINT$_setDatabaseInfo(databaseInfo);
            }
            if (result instanceof ParsingResultAccessor) {
                String sql = args[0] instanceof RegularStatement ? ((RegularStatement)args[0]).getQueryString() : (String)args[0];
                ParsingResult parsingResult = this.traceContext.parseSql(sql);
                if (parsingResult != null) {
                    ((ParsingResultAccessor)result)._$PINPOINT$_setParsingResult(parsingResult);
                } else if (this.logger.isErrorEnabled()) {
                    this.logger.error("sqlParsing fail. parsingResult is null sql:{}", (Object)sql);
                }
            }
        }
    }

    public void doInAfterTrace(SpanEventRecorder recorder, Object target, Object[] args, Object result, Throwable throwable) {
        if (result instanceof ParsingResultAccessor) {
            ParsingResult parsingResult = ((ParsingResultAccessor)result)._$PINPOINT$_getParsingResult();
            recorder.recordSqlParsingResult(parsingResult);
        }
        recorder.recordException(throwable);
        recorder.recordApi(this.methodDescriptor);
    }
}

