/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.netty;

import com.navercorp.pinpoint.bootstrap.config.HttpDumpConfig;
import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;

public class NettyConfig {
    static final String PLUGIN_ENABLE = "profiler.netty";
    static final String HTTP_CODEC_ENABLE = "profiler.netty.http";
    private final boolean pluginEnable;
    private final boolean httpCodecEnable;
    private final boolean param;
    private final HttpDumpConfig httpDumpConfig;

    public NettyConfig(ProfilerConfig config) {
        this.pluginEnable = config.readBoolean(PLUGIN_ENABLE, false);
        this.httpCodecEnable = config.readBoolean(HTTP_CODEC_ENABLE, false);
        this.param = config.readBoolean("profiler.netty.http.param", false);
        this.httpDumpConfig = HttpDumpConfig.getDefault();
    }

    boolean isPluginEnable() {
        return this.pluginEnable;
    }

    boolean isHttpCodecEnable() {
        return this.httpCodecEnable;
    }

    public boolean isParam() {
        return this.param;
    }

    public HttpDumpConfig getHttpDumpConfig() {
        return this.httpDumpConfig;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("NettyConfig{");
        sb.append("pluginEnable=").append(this.pluginEnable);
        sb.append(", httpCodecEnable=").append(this.httpCodecEnable);
        sb.append(", param=").append(this.param);
        sb.append(", httpDumpConfig=").append(this.httpDumpConfig);
        sb.append('}');
        return sb.toString();
    }
}

