/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.hystrix.interceptor;

import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.SpanEventSimpleAroundInterceptorForPlugin;
import com.navercorp.pinpoint.plugin.hystrix.HystrixPluginConstants;
import com.navercorp.pinpoint.plugin.hystrix.field.EnclosingInstanceAccessor;

public abstract class HystrixObservableCallInterceptor
extends SpanEventSimpleAroundInterceptorForPlugin {
    protected HystrixObservableCallInterceptor(TraceContext traceContext, MethodDescriptor methodDescriptor) {
        super(traceContext, methodDescriptor);
    }

    protected void doInBeforeTrace(SpanEventRecorder recorder, Object target, Object[] args) {
    }

    protected void doInAfterTrace(SpanEventRecorder recorder, Object target, Object[] args, Object result, Throwable throwable) {
        recorder.recordServiceType(HystrixPluginConstants.HYSTRIX_INTERNAL_SERVICE_TYPE);
        recorder.recordApi(this.methodDescriptor);
        recorder.recordAttribute(HystrixPluginConstants.HYSTRIX_COMMAND_EXECUTION_ANNOTATION_KEY, this.getExecutionType());
        recorder.recordException(throwable);
    }

    protected abstract String getExecutionType();

    protected Object getEnclosingInstance(Object target) {
        if (!(target instanceof EnclosingInstanceAccessor)) {
            if (this.isDebug) {
                this.logger.debug("Invalid target object. Need field accessor({}).", (Object)EnclosingInstanceAccessor.class.getName());
            }
            return null;
        }
        return ((EnclosingInstanceAccessor)target)._$PINPOINT$_getEnclosingInstance();
    }
}

