/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.okhttp.interceptor;

import com.navercorp.pinpoint.bootstrap.async.AsyncContextAccessor;
import com.navercorp.pinpoint.bootstrap.context.AsyncContext;
import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.plugin.okhttp.OkHttpConstants;

public class DispatcherEnqueueMethodInterceptor
implements AroundInterceptor {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final TraceContext traceContext;
    private final MethodDescriptor methodDescriptor;

    public DispatcherEnqueueMethodInterceptor(TraceContext traceContext, MethodDescriptor methodDescriptor) {
        this.traceContext = traceContext;
        this.methodDescriptor = methodDescriptor;
    }

    public void before(Object target, Object[] args) {
        Trace trace;
        if (this.isDebug) {
            this.logger.beforeInterceptor(target, args);
        }
        if ((trace = this.traceContext.currentTraceObject()) == null) {
            return;
        }
        if (!this.validate(args)) {
            return;
        }
        SpanEventRecorder recorder = trace.traceBlockBegin();
        try {
            AsyncContext asyncContext = recorder.recordNextAsyncContext();
            ((AsyncContextAccessor)args[0])._$PINPOINT$_setAsyncContext(asyncContext);
            if (this.isDebug) {
                this.logger.debug("Set AsyncContext {}", (Object)asyncContext);
            }
        }
        catch (Throwable t) {
            this.logger.warn("Failed to before process. {}", (Object)t.getMessage(), (Object)t);
        }
    }

    private boolean validate(Object[] args) {
        if (args == null || args.length < 1 || !(args[0] instanceof AsyncContextAccessor)) {
            if (this.isDebug) {
                this.logger.debug("Invalid args[0] object {}. Need field accessor({}).", (Object)args, (Object)AsyncContextAccessor.class.getName());
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        Trace trace;
        if (this.isDebug) {
            this.logger.afterInterceptor(target, args);
        }
        if ((trace = this.traceContext.currentTraceObject()) == null) {
            return;
        }
        if (!this.validate(args)) {
            return;
        }
        try {
            SpanEventRecorder recorder = trace.currentSpanEventRecorder();
            recorder.recordApi(this.methodDescriptor);
            recorder.recordServiceType(OkHttpConstants.OK_HTTP_CLIENT_INTERNAL);
            recorder.recordException(throwable);
        }
        finally {
            trace.traceBlockEnd();
        }
    }
}

