/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.hbase.interceptor;

import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.SpanEventSimpleAroundInterceptorForPlugin;
import com.navercorp.pinpoint.plugin.hbase.HbasePluginConstants;
import java.util.List;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;

public class HbaseTableMethodInterceptor
extends SpanEventSimpleAroundInterceptorForPlugin {
    private boolean paramsProfile;

    public HbaseTableMethodInterceptor(TraceContext traceContext, MethodDescriptor descriptor, boolean paramsProfile) {
        super(traceContext, descriptor);
        this.paramsProfile = paramsProfile;
    }

    protected void doInBeforeTrace(SpanEventRecorder recorder, Object target, Object[] args) {
        recorder.recordServiceType(HbasePluginConstants.HBASE_CLIENT_TABLE);
    }

    protected void doInAfterTrace(SpanEventRecorder recorder, Object target, Object[] args, Object result, Throwable throwable) {
        String attributes;
        if (this.paramsProfile && (attributes = this.parseAttributes(args)) != null) {
            recorder.recordAttribute(HbasePluginConstants.HBASE_CLIENT_PARAMS, attributes);
        }
        recorder.recordApi(this.getMethodDescriptor());
        recorder.recordException(throwable);
    }

    protected String parseAttributes(Object[] args) {
        Object param = null;
        if (args != null && args.length == 1) {
            param = args[0];
        } else if (args != null && args.length > 1) {
            param = args[args.length - 1];
        } else {
            return null;
        }
        if (param instanceof Mutation) {
            Mutation mutation = (Mutation)param;
            return "rowKey: " + Bytes.toStringBinary((byte[])mutation.getRow());
        }
        if (param instanceof Get) {
            Get get = (Get)param;
            return "rowKey: " + Bytes.toStringBinary((byte[])get.getRow());
        }
        if (param instanceof Scan) {
            Scan scan = (Scan)param;
            String startRowKey = Bytes.toStringBinary((byte[])scan.getStartRow());
            String stopRowKey = Bytes.toStringBinary((byte[])scan.getStopRow());
            return "startRowKey: " + startRowKey + " stopRowKey: " + stopRowKey;
        }
        if (param instanceof List) {
            List list = (List)param;
            return "size: " + list.size();
        }
        return null;
    }
}

