/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.rabbitmq.client.interceptor;

import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.context.TraceId;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.InterceptorScope;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.common.util.MapUtils;
import com.navercorp.pinpoint.plugin.rabbitmq.client.field.setter.HeadersFieldSetter;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Method;
import java.util.HashMap;
import java.util.Map;

public class AMQCommandConstructInterceptor
implements AroundInterceptor {
    private static final String AMQP_METHOD_TO_INTERCEPT = "basic.publish";
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final TraceContext traceContext;
    private final InterceptorScope scope;

    public AMQCommandConstructInterceptor(TraceContext traceContext, InterceptorScope scope) {
        this.traceContext = traceContext;
        this.scope = scope;
    }

    public void before(Object target, Object[] args) {
        Trace trace;
        if (!this.validate(target, args)) {
            return;
        }
        if (this.isDebug) {
            this.logger.beforeInterceptor(target, args);
        }
        if ((trace = this.traceContext.currentRawTraceObject()) == null) {
            return;
        }
        AMQP.BasicProperties properties = (AMQP.BasicProperties)args[1];
        Map<String, Object> headers = this.createHeader(properties, trace);
        if (headers != null) {
            ((HeadersFieldSetter)properties)._$PINPOINT$_setHeaders(headers);
        }
    }

    private Map<String, Object> createHeader(AMQP.BasicProperties properties, Trace trace) {
        Map<String, Object> headers = this.copyHeader(properties);
        if (trace.canSampled()) {
            TraceId nextId = this.retrieveNextTraceId();
            if (nextId == null) {
                return null;
            }
            headers.put("Pinpoint-TraceID", nextId.getTransactionId());
            headers.put("Pinpoint-SpanID", Long.toString(nextId.getSpanId()));
            headers.put("Pinpoint-pSpanID", Long.toString(nextId.getParentSpanId()));
            headers.put("Pinpoint-pAppType", Short.toString(this.traceContext.getServerTypeCode()));
            headers.put("Pinpoint-pAppName", this.traceContext.getApplicationName());
            headers.put("Pinpoint-Flags", Short.toString(nextId.getFlags()));
        } else {
            headers.put("Pinpoint-Sampled", "1");
        }
        return headers;
    }

    private Map<String, Object> copyHeader(AMQP.BasicProperties properties) {
        Map headers = properties.getHeaders();
        if (MapUtils.isEmpty((Map)headers)) {
            return new HashMap<String, Object>();
        }
        return new HashMap<String, Object>(headers);
    }

    private TraceId retrieveNextTraceId() {
        Object attachment = this.scope.getCurrentInvocation().getAttachment();
        if (attachment == null) {
            if (this.isDebug) {
                this.logger.debug("Invalid attachment. Expected {}, but got null", (Object)TraceId.class.getName());
            }
            return null;
        }
        if (!(attachment instanceof TraceId)) {
            if (this.isDebug) {
                this.logger.debug("Invalid attachment. Expected {}, but got {}", (Object)TraceId.class.getName(), attachment.getClass());
            }
            return null;
        }
        return (TraceId)attachment;
    }

    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        if (!this.validate(target, args)) {
            return;
        }
        if (this.isDebug) {
            this.logger.afterInterceptor(target, args);
        }
    }

    private boolean validate(Object target, Object[] args) {
        if (args == null) {
            if (this.isDebug) {
                this.logger.debug("Expected arguments, but found none.");
            }
            return false;
        }
        if (args.length != 3) {
            if (this.isDebug) {
                this.logger.debug("Expected 3 arguments, but found {}", (Object)args.length);
            }
            return false;
        }
        Object method = args[0];
        if (method == null) {
            return false;
        }
        if (!(method instanceof Method)) {
            if (this.isDebug) {
                this.logger.debug("Expected args[0] to be {}, but was {}", (Object)Method.class.getName(), (Object)method.getClass().getName());
            }
            return false;
        }
        if (!AMQP_METHOD_TO_INTERCEPT.equals(((Method)method).protocolMethodName())) {
            return false;
        }
        Object contentHeader = args[1];
        if (!(contentHeader instanceof AMQP.BasicProperties)) {
            return false;
        }
        if (!(contentHeader instanceof HeadersFieldSetter)) {
            if (this.isDebug) {
                this.logger.debug("Invalid args[1]({}) object. Need field setter({})", contentHeader, (Object)HeadersFieldSetter.class.getName());
            }
            return false;
        }
        return true;
    }
}

