/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.rabbitmq.client;

import com.navercorp.pinpoint.bootstrap.config.ExcludePathFilter;
import com.navercorp.pinpoint.bootstrap.config.Filter;
import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.bootstrap.config.SkipFilter;
import java.util.List;

public class RabbitMQClientPluginConfig {
    private final boolean traceRabbitMQClient;
    private final boolean traceRabbitMQClientProducer;
    private final boolean traceRabbitMQClientConsumer;
    private final List<String> consumerClasses;
    private final Filter<String> excludeExchangeFilter;

    public RabbitMQClientPluginConfig(ProfilerConfig config) {
        this.traceRabbitMQClient = config.readBoolean("profiler.rabbitmq.client.enable", true);
        this.traceRabbitMQClientProducer = config.readBoolean("profiler.rabbitmq.client.producer.enable", true);
        this.traceRabbitMQClientConsumer = config.readBoolean("profiler.rabbitmq.client.consumer.enable", true);
        this.consumerClasses = config.readList("profiler.rabbitmq.client.consumer.classes");
        String excludeExchange = config.readString("profiler.rabbitmq.client.exchange.exclude", "");
        this.excludeExchangeFilter = !excludeExchange.isEmpty() ? new ExcludePathFilter(excludeExchange) : new SkipFilter();
    }

    public boolean isTraceRabbitMQClient() {
        return this.traceRabbitMQClient;
    }

    public boolean isTraceRabbitMQClientProducer() {
        return this.traceRabbitMQClientProducer;
    }

    public boolean isTraceRabbitMQClientConsumer() {
        return this.traceRabbitMQClientConsumer;
    }

    public List<String> getConsumerClasses() {
        return this.consumerClasses;
    }

    public Filter<String> getExcludeExchangeFilter() {
        return this.excludeExchangeFilter;
    }

    public static boolean isExchangeExcluded(String exchange, Filter<String> filter) {
        if (exchange == null || filter == null) {
            return false;
        }
        try {
            if (filter.filter((Object)exchange)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

