/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.plugin.jdbc.bindvalue;

import com.navercorp.pinpoint.bootstrap.plugin.jdbc.bindvalue.BytesConverter;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.bindvalue.ClassNameConverter;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.bindvalue.Converter;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.bindvalue.NullTypeConverter;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.bindvalue.ObjectConverter;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.bindvalue.SimpleTypeConverter;
import java.util.HashMap;
import java.util.Map;

public class BindValueConverter {
    private static final BindValueConverter converter = new BindValueConverter();
    private final Map<String, Converter> convertermap = new HashMap<String, Converter>();

    private void register() {
        this.simpleType();
        this.classNameType();
        this.convertermap.put("setNull", new NullTypeConverter());
        BytesConverter bytesConverter = new BytesConverter();
        this.convertermap.put("setBytes", bytesConverter);
        this.convertermap.put("setObject", new ObjectConverter());
    }

    private void classNameType() {
        ClassNameConverter classNameConverter = new ClassNameConverter();
        this.convertermap.put("setAsciiStream", classNameConverter);
        this.convertermap.put("setUnicodeStream", classNameConverter);
        this.convertermap.put("setBinaryStream", classNameConverter);
        this.convertermap.put("setBlob", classNameConverter);
        this.convertermap.put("setClob", classNameConverter);
        this.convertermap.put("setArray", classNameConverter);
        this.convertermap.put("setNCharacterStream", classNameConverter);
        this.convertermap.put("setNClob", classNameConverter);
        this.convertermap.put("setCharacterStream", classNameConverter);
        this.convertermap.put("setSQLXML", classNameConverter);
    }

    private void simpleType() {
        SimpleTypeConverter simpleTypeConverter = new SimpleTypeConverter();
        this.convertermap.put("setByte", simpleTypeConverter);
        this.convertermap.put("setBoolean", simpleTypeConverter);
        this.convertermap.put("setShort", simpleTypeConverter);
        this.convertermap.put("setInt", simpleTypeConverter);
        this.convertermap.put("setLong", simpleTypeConverter);
        this.convertermap.put("setFloat", simpleTypeConverter);
        this.convertermap.put("setDouble", simpleTypeConverter);
        this.convertermap.put("setBigDecimal", simpleTypeConverter);
        this.convertermap.put("setString", simpleTypeConverter);
        this.convertermap.put("setDate", simpleTypeConverter);
        this.convertermap.put("setTime", simpleTypeConverter);
        this.convertermap.put("setTimestamp", simpleTypeConverter);
        this.convertermap.put("setURL", simpleTypeConverter);
        this.convertermap.put("setRef", simpleTypeConverter);
        this.convertermap.put("setNString", simpleTypeConverter);
    }

    private String convert0(String methodName, Object[] args) {
        Converter converter = this.convertermap.get(methodName);
        if (converter == null) {
            return "";
        }
        return converter.convert(args);
    }

    public static String convert(String methodName, Object[] args) {
        return converter.convert0(methodName, args);
    }

    static {
        converter.register();
    }
}

